/**
 */
package siri.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

import siri.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SiriFactoryImpl extends EFactoryImpl implements SiriFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static SiriFactory init() {
		try {
			SiriFactory theSiriFactory = (SiriFactory)EPackage.Registry.INSTANCE.getEFactory(SiriPackage.eNS_URI);
			if (theSiriFactory != null) {
				return theSiriFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new SiriFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SiriFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case SiriPackage.COUNTRY_REF_STRUCTURE: return createCountryRefStructure();
			case SiriPackage.ENTRY_QUALIFIER_STRUCTURE: return createEntryQualifierStructure();
			case SiriPackage.PARTICIPANT_REF_STRUCTURE: return createParticipantRefStructure();
			case SiriPackage.DOCUMENT_ROOT: return createDocumentRoot();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case SiriPackage.ENVIRONMENT_REASON_ENUMERATION:
				return createEnvironmentReasonEnumerationFromString(eDataType, initialValue);
			case SiriPackage.EQUIPMENT_REASON_ENUMERATION:
				return createEquipmentReasonEnumerationFromString(eDataType, initialValue);
			case SiriPackage.IANA_COUNTRY_TLD_ENUMERATION:
				return createIanaCountryTldEnumerationFromString(eDataType, initialValue);
			case SiriPackage.MISCELLANEOUS_REASON_ENUMERATION:
				return createMiscellaneousReasonEnumerationFromString(eDataType, initialValue);
			case SiriPackage.PERSONNEL_REASON_ENUMERATION:
				return createPersonnelReasonEnumerationFromString(eDataType, initialValue);
			case SiriPackage.COUNTRY_CODE_TYPE:
				return createCountryCodeTypeFromString(eDataType, initialValue);
			case SiriPackage.ENVIRONMENT_REASON_ENUMERATION_OBJECT:
				return createEnvironmentReasonEnumerationObjectFromString(eDataType, initialValue);
			case SiriPackage.EQUIPMENT_REASON_ENUMERATION_OBJECT:
				return createEquipmentReasonEnumerationObjectFromString(eDataType, initialValue);
			case SiriPackage.IANA_COUNTRY_TLD_ENUMERATION_OBJECT:
				return createIanaCountryTldEnumerationObjectFromString(eDataType, initialValue);
			case SiriPackage.MISCELLANEOUS_REASON_ENUMERATION_OBJECT:
				return createMiscellaneousReasonEnumerationObjectFromString(eDataType, initialValue);
			case SiriPackage.PARTICIPANT_CODE_TYPE:
				return createParticipantCodeTypeFromString(eDataType, initialValue);
			case SiriPackage.PERSONNEL_REASON_ENUMERATION_OBJECT:
				return createPersonnelReasonEnumerationObjectFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case SiriPackage.ENVIRONMENT_REASON_ENUMERATION:
				return convertEnvironmentReasonEnumerationToString(eDataType, instanceValue);
			case SiriPackage.EQUIPMENT_REASON_ENUMERATION:
				return convertEquipmentReasonEnumerationToString(eDataType, instanceValue);
			case SiriPackage.IANA_COUNTRY_TLD_ENUMERATION:
				return convertIanaCountryTldEnumerationToString(eDataType, instanceValue);
			case SiriPackage.MISCELLANEOUS_REASON_ENUMERATION:
				return convertMiscellaneousReasonEnumerationToString(eDataType, instanceValue);
			case SiriPackage.PERSONNEL_REASON_ENUMERATION:
				return convertPersonnelReasonEnumerationToString(eDataType, instanceValue);
			case SiriPackage.COUNTRY_CODE_TYPE:
				return convertCountryCodeTypeToString(eDataType, instanceValue);
			case SiriPackage.ENVIRONMENT_REASON_ENUMERATION_OBJECT:
				return convertEnvironmentReasonEnumerationObjectToString(eDataType, instanceValue);
			case SiriPackage.EQUIPMENT_REASON_ENUMERATION_OBJECT:
				return convertEquipmentReasonEnumerationObjectToString(eDataType, instanceValue);
			case SiriPackage.IANA_COUNTRY_TLD_ENUMERATION_OBJECT:
				return convertIanaCountryTldEnumerationObjectToString(eDataType, instanceValue);
			case SiriPackage.MISCELLANEOUS_REASON_ENUMERATION_OBJECT:
				return convertMiscellaneousReasonEnumerationObjectToString(eDataType, instanceValue);
			case SiriPackage.PARTICIPANT_CODE_TYPE:
				return convertParticipantCodeTypeToString(eDataType, instanceValue);
			case SiriPackage.PERSONNEL_REASON_ENUMERATION_OBJECT:
				return convertPersonnelReasonEnumerationObjectToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CountryRefStructure createCountryRefStructure() {
		CountryRefStructureImpl countryRefStructure = new CountryRefStructureImpl();
		return countryRefStructure;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EntryQualifierStructure createEntryQualifierStructure() {
		EntryQualifierStructureImpl entryQualifierStructure = new EntryQualifierStructureImpl();
		return entryQualifierStructure;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParticipantRefStructure createParticipantRefStructure() {
		ParticipantRefStructureImpl participantRefStructure = new ParticipantRefStructureImpl();
		return participantRefStructure;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentRoot createDocumentRoot() {
		DocumentRootImpl documentRoot = new DocumentRootImpl();
		return documentRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnvironmentReasonEnumeration createEnvironmentReasonEnumerationFromString(EDataType eDataType, String initialValue) {
		EnvironmentReasonEnumeration result = EnvironmentReasonEnumeration.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEnvironmentReasonEnumerationToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EquipmentReasonEnumeration createEquipmentReasonEnumerationFromString(EDataType eDataType, String initialValue) {
		EquipmentReasonEnumeration result = EquipmentReasonEnumeration.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEquipmentReasonEnumerationToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IanaCountryTldEnumeration createIanaCountryTldEnumerationFromString(EDataType eDataType, String initialValue) {
		IanaCountryTldEnumeration result = IanaCountryTldEnumeration.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertIanaCountryTldEnumerationToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MiscellaneousReasonEnumeration createMiscellaneousReasonEnumerationFromString(EDataType eDataType, String initialValue) {
		MiscellaneousReasonEnumeration result = MiscellaneousReasonEnumeration.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertMiscellaneousReasonEnumerationToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PersonnelReasonEnumeration createPersonnelReasonEnumerationFromString(EDataType eDataType, String initialValue) {
		PersonnelReasonEnumeration result = PersonnelReasonEnumeration.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPersonnelReasonEnumerationToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IanaCountryTldEnumeration createCountryCodeTypeFromString(EDataType eDataType, String initialValue) {
		return createIanaCountryTldEnumerationFromString(SiriPackage.eINSTANCE.getIanaCountryTldEnumeration(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCountryCodeTypeToString(EDataType eDataType, Object instanceValue) {
		return convertIanaCountryTldEnumerationToString(SiriPackage.eINSTANCE.getIanaCountryTldEnumeration(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnvironmentReasonEnumeration createEnvironmentReasonEnumerationObjectFromString(EDataType eDataType, String initialValue) {
		return createEnvironmentReasonEnumerationFromString(SiriPackage.eINSTANCE.getEnvironmentReasonEnumeration(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEnvironmentReasonEnumerationObjectToString(EDataType eDataType, Object instanceValue) {
		return convertEnvironmentReasonEnumerationToString(SiriPackage.eINSTANCE.getEnvironmentReasonEnumeration(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EquipmentReasonEnumeration createEquipmentReasonEnumerationObjectFromString(EDataType eDataType, String initialValue) {
		return createEquipmentReasonEnumerationFromString(SiriPackage.eINSTANCE.getEquipmentReasonEnumeration(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEquipmentReasonEnumerationObjectToString(EDataType eDataType, Object instanceValue) {
		return convertEquipmentReasonEnumerationToString(SiriPackage.eINSTANCE.getEquipmentReasonEnumeration(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IanaCountryTldEnumeration createIanaCountryTldEnumerationObjectFromString(EDataType eDataType, String initialValue) {
		return createIanaCountryTldEnumerationFromString(SiriPackage.eINSTANCE.getIanaCountryTldEnumeration(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertIanaCountryTldEnumerationObjectToString(EDataType eDataType, Object instanceValue) {
		return convertIanaCountryTldEnumerationToString(SiriPackage.eINSTANCE.getIanaCountryTldEnumeration(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MiscellaneousReasonEnumeration createMiscellaneousReasonEnumerationObjectFromString(EDataType eDataType, String initialValue) {
		return createMiscellaneousReasonEnumerationFromString(SiriPackage.eINSTANCE.getMiscellaneousReasonEnumeration(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertMiscellaneousReasonEnumerationObjectToString(EDataType eDataType, Object instanceValue) {
		return convertMiscellaneousReasonEnumerationToString(SiriPackage.eINSTANCE.getMiscellaneousReasonEnumeration(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String createParticipantCodeTypeFromString(EDataType eDataType, String initialValue) {
		return (String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NMTOKEN, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertParticipantCodeTypeToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NMTOKEN, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PersonnelReasonEnumeration createPersonnelReasonEnumerationObjectFromString(EDataType eDataType, String initialValue) {
		return createPersonnelReasonEnumerationFromString(SiriPackage.eINSTANCE.getPersonnelReasonEnumeration(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPersonnelReasonEnumerationObjectToString(EDataType eDataType, Object instanceValue) {
		return convertPersonnelReasonEnumerationToString(SiriPackage.eINSTANCE.getPersonnelReasonEnumeration(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SiriPackage getSiriPackage() {
		return (SiriPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static SiriPackage getPackage() {
		return SiriPackage.eINSTANCE;
	}

} //SiriFactoryImpl
