/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v2.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 *     Stefan Bishof - API and implementation
 *     Tim Ward - implementation
 */
package de.jena.vdv545.rest;

import org.eclipse.emf.ecore.EObject;
import org.gecko.emf.json.annotation.RequireEMFJson;
import org.gecko.emf.osgi.annotation.require.RequireEMF;
import org.gecko.emf.rest.annotations.RequireEMFMessageBodyReaderWriter;
import org.gecko.emf.rest.annotations.RessourceOverwriteContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsName;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsResource;

import de.jena.vdv454.service.handler.api.ServiceHandler;
import de.jena.vdv454_2017c.VDV453Incl454V2017cPackage;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;





/**
 * This is a Demo Resource for a Jakartars Whiteboard 
 * 
 * @since 1.0
 */
@JakartarsResource
@JakartarsName("vdvRest")
@Component(service = VDV454ServiceEndpointRessource.class, scope = ServiceScope.PROTOTYPE)
@Path("/")
@RequireEMF
@RequireEMFJson
@RequireEMFMessageBodyReaderWriter
public class VDV454ServiceEndpointRessource {


	private static final String IDENTIFIER = "identifier";
	private static final String SERVICE = "service";
	private static final String ACTION = "action";
	
	private static final String MEDIATYPE_TEXT_XML = "text/xml";
	private static final String MEDIATYPE_VDV454 = "application/xml+vdv454";
	
	@Reference
	VDV453Incl454V2017cPackage vdvPackage;
		

	@Reference
	ServiceHandler serviceHandler;
	
	@POST
	@Path("/{" + IDENTIFIER+ "}/{"+SERVICE+"}/{"+ACTION+"}")
	//Consumes(MEDIATYPE_TEXT_XML)
	@Consumes(MediaType.WILDCARD)
	@Produces("text/xml")
	@RessourceOverwriteContentType(VDV453Incl454V2017cPackage.eCONTENT_TYPE)
	public Response action(@PathParam(IDENTIFIER) String identifier, @PathParam(SERVICE) String service, @PathParam(ACTION)String action,
			@RessourceOverwriteContentType(VDV453Incl454V2017cPackage.eCONTENT_TYPE) EObject requestObject) {	
		
			EObject response = serviceHandler.delegateRequest(service, action, requestObject);
			if(response != null) {
				
				return Response.ok(response).build();
			}
			
			return Response.ok().build();
			
	}
	@GET 
	@Path("/")
	public String sayHello() {
		return "hello";
	}
	
	@GET 
	@Path("/{" + IDENTIFIER+ "}/{"+SERVICE+"}/{"+ACTION+"}")
	public String sayHello2(@PathParam(IDENTIFIER) String identifier, @PathParam(SERVICE) String service, @PathParam(ACTION)String action) {
		
		return "hello";
	}
	

}
