package de.jena.vdv454.service.handler;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

import org.eclipse.emf.ecore.EObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventTopics;
import org.eclipse.emf.common.notify.Notifier;

import de.jena.vdv454.mqtt.api.MqttService;
import de.jena.vdv454.service.handler.api.ServiceHandler;
import de.jena.vdv454.service.handler.api.VDVService;

@Component(scope=ServiceScope.SINGLETON)
@EventTopics({"VDVSERVICE/*"})
public class ServiceHandlerImpl implements ServiceHandler, EventHandler  {

	List<VDVService> vdvServices = new LinkedList<VDVService>();
	
	
	@Reference
	MqttService mqtt;
	
	@Reference(cardinality = ReferenceCardinality.MULTIPLE, policy = ReferencePolicy.DYNAMIC)
	private void addVDVService(VDVService service) {
		
		vdvServices.add(service);
	}

	
	private void removeVDVService(VDVService service) {
		vdvServices.remove(service);
	}
	

	/* 
	 * (non-Javadoc)
	 * @see de.jena.vdv545.serviceHandler.ServiceHandler#delegateRequest(java.lang.String, java.lang.String, org.eclipse.emf.ecore.EObject)
	 */
	@Override
	public EObject delegateRequest(String servicename,String action ,EObject e) {
		VDVService service = canHandle(servicename,action);
		if(service == null) return null;
		
		return service.request(action, e);	
	
	}
	public void handleEvent(Event evt) {
		//LOGGER.info("Event arrived for topic " + evt.getTopic());
		String[] split = evt.getTopic().split("/");
		if(split.length>2 && split[0].equals("VDVSERVICE")) {
			
			VDVService service = canHandle(split[1],split[2]);
			EObject ans = service.request(split[2],null);	
			mqtt.publish("VDVSERVICE/"+split[1]+"/data", ans);
		}
		//publish((EObject) evt.getProperty("data"), (String) evt.getProperty("deviceId"), (String) evt.getProperty("deviceType"));
	}
	
	private VDVService canHandle(String servicename, String action) {
		try {
			VDVService service = vdvServices.stream()
					.filter(aService -> aService.canHandle(servicename, action))
					.findFirst()
					.get();
			
			return service;
		
		}catch(NoSuchElementException nse) {
			return null;
		}
		
	}


}
