package de.jena.vdv545.services;

import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.gecko.emf.rest.annotations.RessourceOverwriteContentType;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.promise.PromiseFactory;

import de.jena.vdv454.mqtt.api.MqttService;
import de.jena.vdv454.service.handler.api.VDVService;
import de.jena.vdv454.service.handler.api.VDVServiceConstants;
import de.jena.vdv454.service.handler.api.annotation.AusRefServiceConfig;
import de.jena.vdv454_2017c.AUSNachrichtType;
import de.jena.vdv454_2017c.AboAUSRefType;
import de.jena.vdv454_2017c.AboAnfrageType;
import de.jena.vdv454_2017c.AboAntwortType;
import de.jena.vdv454_2017c.BestaetigungType;
import de.jena.vdv454_2017c.DatenAbrufenAnfrageType;
import de.jena.vdv454_2017c.DatenAbrufenAntwortType;
import de.jena.vdv454_2017c.DocumentRoot;
import de.jena.vdv454_2017c.ErgebnisType;
import de.jena.vdv454_2017c.LinienFahrplanType;
import de.jena.vdv454_2017c.LinienFilterType;
import de.jena.vdv454_2017c.SollFahrtType;
import de.jena.vdv454_2017c.SollUmlaufType;
import de.jena.vdv454_2017c.StatusAnfrageType;
import de.jena.vdv454_2017c.StatusAntwortType;
import de.jena.vdv454_2017c.StatusType;
import de.jena.vdv454_2017c.VDV453Incl454V2017cFactory;
import de.jena.vdv454_2017c.VDV453Incl454V2017cPackage;
import de.jena.vdv454_2017c.ZeitfensterType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;

@Component(immediate = true, configurationPid = "de.jena.vdv454.services.ausref",configurationPolicy = ConfigurationPolicy.REQUIRE)
public class AusRefServiceImpl implements VDVService {

	/** VDVSERVICE_454_SOLLUMLAUF */
	private static final String VDVSERVICE_454_SOLLUMLAUF = "sollumlauf/";
	/** VDVSERVICE_454_PLAN */
	private static final String VDVSERVICE_454_PLAN = "plan/";
	public static final String SERVICENAME = "ausref";
	
	public static final Logger LOGGER = Logger.getLogger(VDVService.class.getName());
	private PromiseFactory promFact = new PromiseFactory(Executors.newSingleThreadExecutor());
	private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
	private EObject data = null;

	@Reference
	jakarta.ws.rs.client.ClientBuilder clientBuilder;

	@Reference(target = "(osgi.jakartars.name=EMFEObjectMessagebodyReaderWriter)")
	MessageBodyReader<EObject> bodyreader;

	@Reference
	VDV453Incl454V2017cPackage ePackage;

	@Reference
	EventAdmin eventAdmin;

	@Reference
	ConfigurationAdmin confAdmin;

	@Reference
	MqttService mqtt;
	
	

	
	
	private Client client;
	private Annotation[] annotations = new Annotation[1];

	private Dictionary<String, Object> configProps;

	private AusRefServiceConfig ausRefConfig;

	public AusRefServiceImpl() {
		annotations[0] = new RessourceOverwriteContentType() {
			public String value() {
				return VDV453Incl454V2017cPackage.eCONTENT_TYPE;
			}

			@Override
			public Class<? extends Annotation> annotationType() {
				return RessourceOverwriteContentType.class;
			};
		};
	}

	
	@Activate
	public void activate(AusRefServiceConfig config) {
		ausRefConfig = config;
		LOGGER.info("AusRefService started");
		LOGGER.info("AusRefService scheduled Subscription for "+ausRefConfig.subscriptionIntervallInHours()+ "hours" );
		client = clientBuilder.register(bodyreader).build();
			scheduledExecutorService.scheduleAtFixedRate(() -> {
				this.subscribe(ausRefConfig.protocol() + "://" + ausRefConfig.host() + ":"
						+ ausRefConfig.port() + "/" + ausRefConfig.operatorId() + "/"
						+ SERVICENAME +"/"+VDVServiceConstants.REQUEST_ABO_MANAGEMENT);

			}, 0, ausRefConfig.subscriptionIntervallInHours(), TimeUnit.HOURS);
	}

	public void deactivate() {
		scheduledExecutorService.shutdown();
	}

	public void subscribe(String url) {

		Resource response = null;
		XMLGregorianCalendar validTo;
		XMLGregorianCalendar now;

		try {
			LOGGER.info("subscriping to "+ url);
			
			XMLGregorianCalendar now2 = getNow();
			javax.xml.datatype.Duration addOneDay = DatatypeFactory.newInstance().newDurationDayTime(true, 1, 0, 0, 0);
			//now2.add(addOneDay);
			validTo = now2;
			GregorianCalendar dayStart = new GregorianCalendar();
			dayStart.set(now2.getYear(), now2.getMonth() - 1, now2.getDay(), 0, 0);
			dayStart.setTimeZone(TimeZone.getDefault());
			GregorianCalendar dayEnd = new GregorianCalendar();
			dayEnd.set(now2.getYear(), now2.getMonth() - 1, now2.getDay() + 1, 0, 0);
			dayEnd.setTimeZone(TimeZone.getDefault());

			// DatatypeFactory.newInstance().newXMLGregorianCalendar(2024,3,7,0,0,0,0,0);
			GregorianCalendar cal = new GregorianCalendar();
			cal.setTime(new Date());
			cal.setTimeZone(TimeZone.getDefault());
			now = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);

			AboAnfrageType aboRequest = VDV453Incl454V2017cFactory.eINSTANCE.createAboAnfrageType();
			AboAUSRefType aboAusRef = VDV453Incl454V2017cFactory.eINSTANCE.createAboAUSRefType();
			DocumentRoot root = VDV453Incl454V2017cFactory.eINSTANCE.createDocumentRoot();
			ZeitfensterType zft = VDV453Incl454V2017cFactory.eINSTANCE.createZeitfensterType();

			for (String linienFilter : ausRefConfig.linienFilter()) {
				LinienFilterType linienFilterType = VDV453Incl454V2017cFactory.eINSTANCE.createLinienFilterType();
				linienFilterType.setLinienID(linienFilter);
				aboAusRef.getLinienFilter().add(linienFilterType);
			}
			aboAusRef.setAboID(new BigInteger(ausRefConfig.aboId()));
			aboAusRef.setVerfallZst(DatatypeFactory.newInstance().newXMLGregorianCalendar(dayEnd));

			zft.setGueltigVon(DatatypeFactory.newInstance().newXMLGregorianCalendar(dayStart));
			zft.setGueltigBis(DatatypeFactory.newInstance().newXMLGregorianCalendar(dayEnd));
			aboAusRef.setZeitfenster(zft);
			aboRequest.setZst(now);
			aboRequest.setSender(ausRefConfig.operatorId());
			aboRequest.getAboAUSRef().add(aboAusRef);

			LOGGER.info("#### Request subscription ####\n"
					+ "from:"+ DatatypeFactory.newInstance().newXMLGregorianCalendar(dayStart).toString() +'\n'
					+ "to:"+ DatatypeFactory.newInstance().newXMLGregorianCalendar(dayEnd).toString()+'\n'
					+ "sender:"+ausRefConfig.operatorId()+'\n'
					+ "aboid:"+new BigInteger(ausRefConfig.aboId())+'\n');
	
		
			root.setAboAnfrage(aboRequest);
			LOGGER.info("Subscription sended");
			try {
			Entity<DocumentRoot> entity = Entity.entity(root, "text/xml");
			Response post = client.target(url).request().post(entity);
			//LOGGER.info(post.toString());

			

				DocumentRoot dr = post.readEntity(DocumentRoot.class);
				AboAntwortType aw = dr.getAboAntwort();

				if (aw != null) {
					BestaetigungType bs = aw.getBestaetigung();
					LOGGER.info(url);
					if (bs.getErgebnis().equals(ErgebnisType.OK)) {
						
						LOGGER.info("Subscription accepted");
					} else {
						LOGGER.info("Subscription failed");
						LOGGER.info(bs.getFehlertext());
					}
				}
			} catch (Exception e) {
				LOGGER.log(Level.WARNING,"Exception while subscribe sending anwser",e);
			}

		} catch (DatatypeConfigurationException e) {
			// TODO Auto-generated catch block
			
			LOGGER.log(Level.WARNING,"Exception while subscribe",e);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.jena.vdv545.serviceHandler.api.VDVService#canHandle(java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public boolean canHandle(String servicename, String action) {

		if (servicename.equals(SERVICENAME))
			return true;

		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.jena.vdv545.serviceHandler.api.VDVService#request(java.lang.String,
	 * java.lang.String, org.eclipse.emf.ecore.EObject)
	 */
	@Override
	public EObject request(String action, EObject e) {

		switch (action) {

		case VDVServiceConstants.REQUEST_READY:
			return handleDataReadyRequest(e);

		case VDVServiceConstants.REQUEST_STATUS:
			return handleAliveRequest(e);

		case VDVServiceConstants.REQUEST_RETRIVE:
			return data;
	
		default:
			return null;
		}

	}

	public Boolean retriveData() {

		DocumentRoot root = VDV453Incl454V2017cFactory.eINSTANCE.createDocumentRoot();
		DatenAbrufenAnfrageType datenAbrufenAnfrage = VDV453Incl454V2017cFactory.eINSTANCE
				.createDatenAbrufenAnfrageType();

		try {
			LOGGER.info("Request <DatenAbrufAnfrage>");
			EcoreUtil.equals(root, datenAbrufenAnfrage);
			datenAbrufenAnfrage.setSender(ausRefConfig.operatorId());
			datenAbrufenAnfrage.setZst(getNow());

			root.setDatenAbrufenAnfrage(datenAbrufenAnfrage);
			Entity<DocumentRoot> entity = Entity.entity(root, "text/xml");
			Response post = client.target(ausRefConfig.protocol() + "://"
					+ ausRefConfig.host() + ":" + ausRefConfig.port() + "/"
					+ ausRefConfig.operatorId() + "/" + SERVICENAME + "/"+VDVServiceConstants.REQUEST_RETRIVE

			).request().post(entity);

			LOGGER.info("<DatenAbrufAnfrage> received");
			DocumentRoot dr = post.readEntity(DocumentRoot.class);
			DatenAbrufenAntwortType inner_ans = dr.getDatenAbrufenAntwort();
			EList<AUSNachrichtType> aus_msgs = inner_ans.getAUSNachricht();

			Map<String,Map<String,List<SollFahrtType>>> fahrtCache = new HashMap();
			
			if (aus_msgs != null) {
				data = inner_ans;
				
				aus_msgs.forEach(ausn -> {

					Collection<LinienFahrplanType> fahrplanList = EcoreUtil.copyAll(ausn.getLinienfahrplan());

					fahrplanList.forEach(fahrplan -> {
						
						String linie = fahrplan.getLinienID();
						String richtung = fahrplan.getRichtungsID();
						LinienFahrplanType fplnc = EcoreUtil.copy(fahrplan);
						fplnc.getSollFahrt().clear();
						
						Collection<SollFahrtType> sollFahrtList = EcoreUtil.copyAll(fahrplan.getSollFahrt());
						
						sollFahrtList.forEach(sollPlan->{
							
							if(!fahrtCache.containsKey(linie)) {
						    	fahrtCache.put(linie, new HashMap<String,List<SollFahrtType>>());
						    }
						    Map<String, List<SollFahrtType>> lineMap = fahrtCache.get(linie);
						    if(!lineMap.containsKey(richtung)) {
						    	lineMap.put(richtung, new ArrayList<SollFahrtType>());
						    }
						    List<SollFahrtType> richtungList = lineMap.get(richtung);
						    richtungList.add(sollPlan);
						});


						LOGGER.info("<DatenAbrufAnfrage> publishing line:"+linie+" dir:"+richtung+" summery info");
					mqtt.publish(ausRefConfig.mqttSubtopic()+"/"+VDVSERVICE_454_PLAN + linie+"/"+richtung, fplnc);
					});
					Collection<SollUmlaufType> sollUmlfList = EcoreUtil.copyAll(ausn.getSollUmlauf());
					sollUmlfList.forEach(istUmlf -> {
						String umlid = istUmlf.getUmlaufID();
						mqtt.publish(ausRefConfig.mqttSubtopic()+"/"+VDVSERVICE_454_SOLLUMLAUF + umlid, istUmlf);
					});
				});
				
				fahrtCache.forEach((linie,richtungsmapMap)->{
					richtungsmapMap.forEach((richtung,sollfahrtlist)->{
						mqtt.publish(ausRefConfig.mqttSubtopic()+"/"+VDVSERVICE_454_PLAN + linie+"/"+richtung+"/fahrt",sollfahrtlist);
						LOGGER.info("<DatenAbrufAnfrage> publishing line:"+linie+" dir:"+richtung+" sollfahrt list");
					});
				}); 
					
				
				
				
			} else {
				LOGGER.warning("Got no Aus Message");
			}
		} catch (DatatypeConfigurationException e) {
			LOGGER.log(Level.WARNING,"Exception while retrive Data",e);
		}

		return false;
	}

	private EObject handleDataReadyRequest(EObject e) {
		LOGGER.info("Got <DatenAbrufAnfrage> Request");
		
		XMLGregorianCalendar now;
		try {
			GregorianCalendar cal = new GregorianCalendar();
			cal.setTime(new Date());
			now = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);

			DatenAbrufenAntwortType daat = VDV453Incl454V2017cFactory.eINSTANCE.createDatenAbrufenAntwortType();
			BestaetigungType bst = VDV453Incl454V2017cFactory.eINSTANCE.createBestaetigungType();
			bst.setErgebnis(ErgebnisType.OK);
			bst.setZst(now);

			daat.setBestaetigung(bst);
			LOGGER.info("send <DatenAbrufenAntwortType>");
			promFact.submit(this::retriveData).onFailure(AusRefServiceImpl::error);

			return daat;

		} catch (DatatypeConfigurationException e1) {
			LOGGER.log(Level.WARNING,"Exception while handleDataReadyRequest",e1);
			return null;
		}

	}

	private EObject handleAliveRequest(EObject e) {
		
		if (e.getClass() != DocumentRoot.class)
			return null;
		DocumentRoot dr = (DocumentRoot) e;
		StatusAnfrageType req = dr.getStatusAnfrage();
		if (req == null)
			return null;

		StatusAntwortType ans = VDV453Incl454V2017cFactory.eINSTANCE.createStatusAntwortType();
		StatusType status = VDV453Incl454V2017cFactory.eINSTANCE.createStatusType();

		status.setErgebnis(ErgebnisType.OK);
		try {
			status.setZst(getNow());
		} catch (DatatypeConfigurationException e1) {
			// TODO Auto-generated catch block
			LOGGER.log(Level.WARNING,"Could  not set Response Time",e1);
			return null;
		}
		ans.setStatus(status);
		return ans;
	}	

	private XMLGregorianCalendar getNow() throws DatatypeConfigurationException {
		XMLGregorianCalendar now;
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(new Date());
		cal.setTimeZone(TimeZone.getDefault());
		return now = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
	}

	private static void error(Throwable t) {
		LOGGER.log(Level.SEVERE,"Exception while retrive Data",t);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.jena.vdv545.serviceHandler.api.VDVService#getData()
	 */
	@Override
	public EObject getData() {
		// TODO Auto-generated method stub
		return data;
	}

}
