/**
 * Copyright (c) 2014 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.util.registry;

import java.util.List;

import org.eclipse.emf.ecore.EObject;

/**
 * Interface to initialize the registry. This initializer is intended to use as OSGi service. The Initializer should be injected into the registry.
 * @author Mark Hoffmann
 * @since 08.09.2014
 */
public interface RegistryIntializer<T extends EObject> {
	
	/**
	 * Called when the registry is initialized and adds the returned objects to the registry 
	 * @return a {@link List} of objects to register
	 */
	public List<T> initializeRegistry();
	
	/**
	 * Called when the registry is closing an removes the returning objects from the registry
	 * @return {@link List} of object to remove from the registry
	 */
	public List<T> disposeRegistry();

}
