/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.filters;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Providers;
import org.pac4j.core.config.Config;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.jax.rs.filters.JaxRsHttpActionAdapter;
import org.pac4j.jax.rs.helpers.ProvidersContext;
import org.pac4j.jax.rs.helpers.RequestJaxRsContext;
import org.pac4j.jax.rs.pac4j.JaxRsContext;

public abstract class AbstractFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    protected Boolean skipResponse;
    private final Providers providers;

    public AbstractFilter(Providers providers) {
        this.providers = providers;
    }

    protected Config getConfig() {
        return new ProvidersContext(this.providers).resolveNotNull(Config.class);
    }

    protected abstract void filter(JaxRsContext var1) throws IOException;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.filter(new RequestJaxRsContext(this.providers, requestContext).contextOrNew());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (this.skipResponse == null || !this.skipResponse.booleanValue()) {
            new RequestJaxRsContext(this.providers, requestContext).contextOrNew().getResponseHolder().populateResponse(responseContext);
        }
    }

    protected HttpActionAdapter<Object, JaxRsContext> adapter(Config config) {
        JaxRsHttpActionAdapter adapter = config.getHttpActionAdapter() != null ? config.getHttpActionAdapter() : JaxRsHttpActionAdapter.INSTANCE;
        return (code, context) -> {
            if (this.skipResponse == null || !this.skipResponse.booleanValue()) {
                adapter.adapt(code, context);
            }
            return null;
        };
    }

    public Boolean isSkipResponse() {
        return this.skipResponse;
    }

    public void setSkipResponse(Boolean skipResponse) {
        this.skipResponse = skipResponse;
    }
}

