/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.filters;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.ext.Providers;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.jax.rs.filters.AbstractFilter;
import org.pac4j.jax.rs.pac4j.JaxRsContext;
import org.pac4j.jax.rs.pac4j.JaxRsProfileManager;

@Priority(value=2000)
public class CallbackFilter
extends AbstractFilter {
    private CallbackLogic<Object, JaxRsContext> callbackLogic;
    private String defaultUrl;
    private Boolean saveInSession;
    private Boolean multiProfile;
    private Boolean renewSession;
    private String defaultClient;

    public CallbackFilter(Providers providers) {
        super(providers);
    }

    @Override
    protected void filter(JaxRsContext context) throws IOException {
        Config config = this.getConfig();
        this.buildLogic(config).perform((WebContext)context, config, this.adapter(config), context.getAbsolutePath(this.defaultUrl, false), this.saveInSession, this.multiProfile, this.renewSession, this.defaultClient);
    }

    protected CallbackLogic<Object, JaxRsContext> buildLogic(Config config) {
        if (this.callbackLogic != null) {
            return this.callbackLogic;
        }
        if (config.getCallbackLogic() != null) {
            return config.getCallbackLogic();
        }
        DefaultCallbackLogic logic = new DefaultCallbackLogic();
        logic.setProfileManagerFactory(JaxRsProfileManager::new);
        return logic;
    }

    public CallbackLogic<Object, JaxRsContext> getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic<Object, JaxRsContext> callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public boolean isSaveInSession() {
        return this.saveInSession;
    }

    public void setSaveInSession(Boolean saveInSession) {
        this.saveInSession = saveInSession;
    }

    public boolean isMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public boolean isRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }
}

