/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.grizzly.pac4j;

import java.util.HashMap;
import org.glassfish.grizzly.http.server.Session;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jax.rs.grizzly.pac4j.GrizzlyJaxRsContext;
import org.pac4j.jax.rs.pac4j.JaxRsContext;

public class GrizzlySessionStore
implements SessionStore<JaxRsContext> {
    public Session getSession(JaxRsContext context) {
        assert (context instanceof GrizzlyJaxRsContext);
        return ((GrizzlyJaxRsContext)context).getRequest().getSession();
    }

    public String getOrCreateSessionId(JaxRsContext context) {
        return this.getSession(context).getIdInternal();
    }

    public Object get(JaxRsContext context, String key) {
        return this.getSession(context).getAttribute(key);
    }

    public void set(JaxRsContext context, String key, Object value) {
        if (value == null) {
            this.getSession(context).removeAttribute(key);
        } else {
            this.getSession(context).setAttribute(key, value);
        }
    }

    public boolean destroySession(JaxRsContext context) {
        Session session = this.getSession(context);
        session.setValid(false);
        return true;
    }

    public Object getTrackableSession(JaxRsContext context) {
        return this.getSession(context);
    }

    public boolean renewSession(JaxRsContext context) {
        Session session = this.getSession(context);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(session.attributes());
        session.setValid(false);
        Session newSession = this.getSession(context);
        attributes.forEach((arg_0, arg_1) -> ((Session)newSession).setAttribute(arg_0, arg_1));
        return true;
    }

    public SessionStore<JaxRsContext> buildFromTrackableSession(JaxRsContext context, final Object trackableSession) {
        return new GrizzlySessionStore(){

            @Override
            public Session getSession(JaxRsContext context) {
                return (Session)trackableSession;
            }
        };
    }
}

