/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class AnnotationsHelper {
    private AnnotationsHelper() {
    }

    public static <A extends Annotation> A getClassLevelAnnotation(Class<?> clazz, Class<A> annotationClass) {
        A foundOnInterface = null;
        Class<?> cls = clazz;
        block0: do {
            A a;
            if ((a = cls.getAnnotation(annotationClass)) != null) {
                return a;
            }
            if (foundOnInterface != null) continue;
            for (Class<?> itf : cls.getInterfaces()) {
                a = itf.getAnnotation(annotationClass);
                if (a == null) continue;
                foundOnInterface = a;
                continue block0;
            }
        } while ((cls = cls.getSuperclass()) != null);
        return foundOnInterface;
    }

    public static <A extends Annotation> A getMethodLevelAnnotation(Method m, Class<A> annotationClass) {
        return AnnotationsHelper.getMethodLevelAnnotation(m, m.getDeclaringClass(), annotationClass);
    }

    private static <A extends Annotation> A getMethodLevelAnnotation(Method m, Class<?> c, Class<A> annotationClass) {
        Method rm = AnnotationsHelper.findMethod(m, c);
        if (rm == null) {
            return null;
        }
        A a = rm.getAnnotation(annotationClass);
        if (a != null) {
            return a;
        }
        Class<?> sc = c.getSuperclass();
        if (sc != null && sc != Object.class && (a = AnnotationsHelper.getMethodLevelAnnotation(m, sc, annotationClass)) != null) {
            return a;
        }
        for (Class<?> i : c.getInterfaces()) {
            a = AnnotationsHelper.getMethodLevelAnnotation(m, i, annotationClass);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    private static Method findMethod(final Method m, final Class<?> c) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return c.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }
}

