/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.jersey.features;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jax.rs.annotations.Pac4JProfile;
import org.pac4j.jax.rs.annotations.Pac4JProfileManager;
import org.pac4j.jax.rs.helpers.RequestCommonProfile;
import org.pac4j.jax.rs.helpers.RequestJaxRsContext;
import org.pac4j.jax.rs.helpers.RequestPac4JSecurityContext;
import org.pac4j.jax.rs.helpers.RequestProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pac4JValueFactoryProvider {
    private static Logger LOG = LoggerFactory.getLogger(Pac4JValueFactoryProvider.class);

    private static Optional<CommonProfile> optionalProfile(ContainerRequest containerRequest) {
        RequestPac4JSecurityContext securityContext = new RequestPac4JSecurityContext((ContainerRequestContext)containerRequest);
        return new RequestCommonProfile(securityContext).profile();
    }

    public static class DefaultProfileManagerFactoryBuilder
    implements ProfileManagerFactoryBuilder {
        @Context
        private Providers providers;

        @Override
        public ProfileManagerFactory get() {
            return new ProfileManagerValueFactory(this.providers);
        }
    }

    static class OptionalProfileValueFactory
    implements OptionalProfileFactory {
        OptionalProfileValueFactory() {
        }

        @Override
        public Optional<CommonProfile> apply(ContainerRequest containerRequest) {
            return Pac4JValueFactoryProvider.optionalProfile(containerRequest);
        }
    }

    static class ProfileValueFactory
    implements ProfileFactory {
        ProfileValueFactory() {
        }

        @Override
        public CommonProfile apply(ContainerRequest containerRequest) {
            return (CommonProfile)Pac4JValueFactoryProvider.optionalProfile(containerRequest).orElseThrow(() -> {
                LOG.debug("Cannot inject a Pac4j profile into an unauthenticated request, responding with 401");
                return new WebApplicationException(401);
            });
        }
    }

    static class ProfileManagerValueFactory
    implements ProfileManagerFactory {
        @Context
        private final Providers providers;

        ProfileManagerValueFactory(Providers providers) {
            this.providers = providers;
        }

        @Override
        public ProfileManager<CommonProfile> apply(ContainerRequest containerRequest) {
            return new RequestProfileManager(new RequestJaxRsContext(this.providers, (ContainerRequestContext)containerRequest)).profileManager();
        }
    }

    public static class Binder
    extends AbstractBinder {
        private final ProfileFactoryBuilder profile;
        private final OptionalProfileFactoryBuilder optProfile;
        private final ProfileManagerFactoryBuilder manager;

        public Binder() {
            this(null, null, null);
        }

        public Binder(ProfileFactoryBuilder profile, OptionalProfileFactoryBuilder optProfile, ProfileManagerFactoryBuilder manager) {
            this.profile = profile == null ? ProfileValueFactory::new : profile;
            this.optProfile = optProfile == null ? OptionalProfileValueFactory::new : optProfile;
            this.manager = manager;
        }

        public Binder(CommonProfile profile) {
            this(() -> ignored -> profile, () -> ignored -> Optional.ofNullable(profile), null);
        }

        public Binder(Supplier<CommonProfile> profile) {
            this(() -> arg_0 -> Binder.lambda$null$4((Supplier)profile, arg_0), () -> arg_0 -> Binder.lambda$null$6((Supplier)profile, arg_0), null);
        }

        protected void configure() {
            this.bind(this.profile).to(ProfileFactoryBuilder.class);
            this.bind(this.optProfile).to(OptionalProfileFactoryBuilder.class);
            if (this.manager == null) {
                this.bind(DefaultProfileManagerFactoryBuilder.class).to(ProfileManagerFactoryBuilder.class);
            } else {
                this.bind(this.manager).to(ProfileManagerFactoryBuilder.class);
            }
            ((ClassBinding)this.bind(Pac4JProfileValueFactoryProvider.class).to(ValueParamProvider.class)).in(Singleton.class);
            ((ClassBinding)this.bind(ProfileInjectionResolver.class).to((GenericType)new GenericType<InjectionResolver<Pac4JProfile>>(){})).in(Singleton.class);
            ((ClassBinding)this.bind(ProfileManagerInjectionResolver.class).to((GenericType)new GenericType<InjectionResolver<Pac4JProfileManager>>(){})).in(Singleton.class);
        }

        private static /* synthetic */ Optional lambda$null$6(Supplier profile, ContainerRequest ignored) {
            return Optional.ofNullable(profile.get());
        }

        private static /* synthetic */ CommonProfile lambda$null$4(Supplier profile, ContainerRequest ignored) {
            return (CommonProfile)profile.get();
        }
    }

    public static interface ProfileManagerFactoryBuilder
    extends Supplier<ProfileManagerFactory> {
    }

    public static interface ProfileManagerFactory
    extends Function<ContainerRequest, ProfileManager<CommonProfile>> {
    }

    public static interface ProfileFactoryBuilder
    extends Supplier<ProfileFactory> {
    }

    public static interface ProfileFactory
    extends Function<ContainerRequest, CommonProfile> {
    }

    public static interface OptionalProfileFactoryBuilder
    extends Supplier<OptionalProfileFactory> {
    }

    public static interface OptionalProfileFactory
    extends Function<ContainerRequest, Optional<CommonProfile>> {
    }

    static class ProfileInjectionResolver
    extends ParamInjectionResolver<Pac4JProfile> {
        @Inject
        ProfileInjectionResolver(Pac4JProfileValueFactoryProvider valueFactoryProvider, Provider<ContainerRequest> containerRequestProvider) {
            super((ValueParamProvider)valueFactoryProvider, Pac4JProfile.class, containerRequestProvider);
        }
    }

    static class ProfileManagerInjectionResolver
    extends ParamInjectionResolver<Pac4JProfileManager> {
        @Inject
        ProfileManagerInjectionResolver(Pac4JProfileValueFactoryProvider valueFactoryProvider, Provider<ContainerRequest> containerRequestProvider) {
            super((ValueParamProvider)valueFactoryProvider, Pac4JProfileManager.class, containerRequestProvider);
        }
    }

    static class Pac4JProfileValueFactoryProvider
    extends AbstractValueParamProvider {
        private final ProfileManagerFactoryBuilder manager;
        private final OptionalProfileFactoryBuilder optProfile;
        private final ProfileFactoryBuilder profile;

        @Inject
        protected Pac4JProfileValueFactoryProvider(ProfileManagerFactoryBuilder manager, OptionalProfileFactoryBuilder opt, ProfileFactoryBuilder profile, Provider<MultivaluedParameterExtractorProvider> mpep) {
            super(mpep, new Parameter.Source[]{Parameter.Source.UNKNOWN});
            this.manager = manager;
            this.optProfile = opt;
            this.profile = profile;
        }

        protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
            if (parameter.isAnnotationPresent(Pac4JProfileManager.class)) {
                if (ProfileManager.class.isAssignableFrom(parameter.getRawType())) {
                    return (Function)this.manager.get();
                }
                throw new IllegalStateException("Cannot inject a Pac4J profile manager into a parameter of type " + parameter.getRawType().getName());
            }
            if (parameter.isAnnotationPresent(Pac4JProfile.class)) {
                if (CommonProfile.class.isAssignableFrom(parameter.getRawType())) {
                    return (Function)this.profile.get();
                }
                if (Optional.class.isAssignableFrom(parameter.getRawType())) {
                    ClassTypePair ctp;
                    List ctps = ReflectionHelper.getTypeArgumentAndClass((Type)parameter.getRawType());
                    ClassTypePair classTypePair = ctp = ctps.size() == 1 ? (ClassTypePair)ctps.get(0) : null;
                    if (ctp == null || CommonProfile.class.isAssignableFrom(ctp.rawClass())) {
                        return (Function)this.optProfile.get();
                    }
                }
                throw new IllegalStateException("Cannot inject a Pac4J profile into a parameter of type " + parameter.getRawType().getName());
            }
            return null;
        }
    }
}

