/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.pac4j;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

public class JaxRsContext
implements WebContext {
    public static final String RESPONSE_HOLDER = JaxRsContext.class + ".ResponseHolder";
    private final ContainerRequestContext requestContext;
    private final SessionStore sessionStore;
    private final Providers providers;
    private Response.ResponseBuilder abortResponse = null;
    private MultivaluedMap<String, String> parameters = null;

    public JaxRsContext(Providers providers, ContainerRequestContext requestContext, SessionStore sessionStore) {
        this.providers = providers;
        this.requestContext = requestContext;
        this.sessionStore = sessionStore;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public ContainerRequestContext getRequestContext() {
        return this.requestContext;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public Response.ResponseBuilder getAbortBuilder() {
        if (this.abortResponse == null) {
            this.abortResponse = Response.ok();
        }
        return this.abortResponse;
    }

    public ResponseHolder getResponseHolder() {
        ResponseHolder prop = (ResponseHolder)this.requestContext.getProperty(RESPONSE_HOLDER);
        if (prop == null) {
            prop = new ResponseHolder();
            this.requestContext.setProperty(RESPONSE_HOLDER, (Object)prop);
        }
        return prop;
    }

    public void writeResponseContent(String content) {
        this.getAbortBuilder().entity((Object)content);
        this.getResponseHolder().writeResponseContent(content);
    }

    public void setResponseStatus(int code) {
        this.getAbortBuilder().status(code);
        this.getResponseHolder().setResponseStatus(code);
    }

    public void setResponseHeader(String name, String value) {
        CommonHelper.assertNotNull((String)"name", (Object)name);
        this.getAbortBuilder().header(name, null);
        this.getAbortBuilder().header(name, (Object)value);
        this.getResponseHolder().setResponseHeader(name, value);
    }

    public void setResponseContentType(String content) {
        MediaType type = content == null ? null : MediaType.valueOf((String)content);
        this.getAbortBuilder().type(type);
        this.getResponseHolder().setResponseContentType(type);
    }

    public void addResponseCookie(Cookie cookie) {
        CommonHelper.assertNotNull((String)"cookie", (Object)cookie);
        NewCookie c = new NewCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), cookie.getMaxAge(), null, cookie.isSecure(), cookie.isHttpOnly());
        this.getAbortBuilder().cookie(new NewCookie[]{c});
        this.getResponseHolder().addResponseCookie(c);
    }

    public String getPath() {
        return "/" + this.requestContext.getUriInfo().getPath();
    }

    public String getAbsolutePath(String relativePath, boolean full) {
        if (relativePath == null) {
            return null;
        }
        if (relativePath.startsWith("/")) {
            URI baseUri = this.requestContext.getUriInfo().getBaseUri();
            String urlPrefix = full ? baseUri.toString() : baseUri.getPath();
            return urlPrefix + relativePath.substring(1);
        }
        return relativePath;
    }

    public String getRequestParameter(String name) {
        return (String)this.extractedParameters().getFirst((Object)name);
    }

    public Map<String, String[]> getRequestParameters() {
        return JaxRsContext.transform(this.extractedParameters(), l -> l.toArray(new String[l.size()]));
    }

    private static <X, Y, Z> Map<X, Z> transform(Map<? extends X, ? extends Y> input, Function<Y, Z> function) {
        return input.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> function.apply(e.getValue())));
    }

    private MultivaluedMap<String, String> extractedParameters() {
        if (this.parameters == null) {
            MultivaluedHashMap multivaluedHashMap = new MultivaluedHashMap();
            multivaluedHashMap.putAll((Map)this.requestContext.getUriInfo().getQueryParameters());
            this.parameters = multivaluedHashMap;
            if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(this.requestContext.getMediaType())) {
                this.readAndResetEntityStream(stream -> {
                    try {
                        Form form = (Form)this.providers.getMessageBodyReader(Form.class, Form.class, new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE).readFrom(Form.class, Form.class, new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE, this.requestContext.getHeaders(), stream);
                        form.asMap().forEach((arg_0, arg_1) -> this.parameters.addAll(arg_0, arg_1));
                        return null;
                    }
                    catch (IOException e) {
                        throw new TechnicalException((Throwable)e);
                    }
                });
            }
        }
        return this.parameters;
    }

    public Object getRequestAttribute(String name) {
        return this.requestContext.getProperty(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this.requestContext.setProperty(name, value);
    }

    public String getRequestHeader(String name) {
        return this.requestContext.getHeaderString(name);
    }

    public String getRequestMethod() {
        return this.requestContext.getMethod();
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getServerName() {
        return this.getRequestUri().getHost();
    }

    public int getServerPort() {
        return this.getRequestUri().getPort();
    }

    public String getScheme() {
        return this.getRequestUri().getScheme();
    }

    public String getFullRequestURL() {
        return this.getRequestUri().toString();
    }

    private URI getRequestUri() {
        return this.requestContext.getUriInfo().getRequestUri();
    }

    public boolean isSecure() {
        return this.requestContext.getSecurityContext().isSecure();
    }

    public Collection<Cookie> getRequestCookies() {
        return this.requestContext.getCookies().values().stream().map(c -> {
            Cookie nc = new Cookie(c.getName(), c.getValue());
            nc.setDomain(c.getDomain());
            nc.setPath(c.getPath());
            nc.setVersion(c.getVersion());
            return nc;
        }).collect(Collectors.toList());
    }

    public String getRequestContent() {
        return this.readAndResetEntityStream(stream -> {
            String charsetS = (String)this.requestContext.getMediaType().getParameters().get("charset");
            Charset charset = charsetS != null ? Charset.forName(charsetS) : Charset.defaultCharset();
            String content = new BufferedReader(new InputStreamReader((InputStream)stream, charset)).lines().reduce("", (accumulator, actual) -> accumulator.concat((String)actual));
            return content;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private <T> T readAndResetEntityStream(Function<InputStream, T> f) {
        try {
            Throwable throwable = null;
            try (InputStream entityStream = this.requestContext.getEntityStream();){
                InputStream inputStream;
                int len;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = entityStream.read(buffer)) > -1) {
                    baos.write(buffer, 0, len);
                }
                baos.flush();
                ByteArrayInputStream stream = new ByteArrayInputStream(baos.toByteArray());
                try {
                    inputStream = f.apply(stream);
                    stream.reset();
                }
                catch (Throwable throwable2) {
                    try {
                        stream.reset();
                        this.requestContext.setEntityStream((InputStream)stream);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                this.requestContext.setEntityStream((InputStream)stream);
                return (T)inputStream;
            }
        }
        catch (IOException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public static class ResponseHolder {
        private boolean hasResponseContent = false;
        private String responseContent = null;
        private boolean hasResponseStatus = false;
        private int responseStatus = 0;
        private boolean hasResponseContentType = false;
        private MediaType responseContentType = null;
        private final Map<String, String> responseHeaders = new HashMap<String, String>();
        private final Set<NewCookie> responseCookies = new HashSet<NewCookie>();

        public void writeResponseContent(String content) {
            this.responseContent = content;
            this.hasResponseContent = true;
        }

        public void setResponseStatus(int code) {
            this.responseStatus = code;
            this.hasResponseStatus = true;
        }

        public void setResponseHeader(String name, String value) {
            this.responseHeaders.put(name, value);
        }

        public void addResponseCookie(NewCookie cookie) {
            this.responseCookies.add(cookie);
        }

        public void setResponseContentType(MediaType type) {
            this.responseContentType = type;
            this.hasResponseContentType = true;
        }

        public void populateResponse(ContainerResponseContext responseContext) {
            if (this.hasResponseContent) {
                responseContext.setEntity((Object)this.responseContent);
            }
            if (this.hasResponseContentType) {
                responseContext.getHeaders().putSingle((Object)"Content-Type", (Object)this.responseContentType);
            }
            if (this.hasResponseStatus) {
                responseContext.setStatus(this.responseStatus);
            }
            for (Map.Entry<String, String> headers : this.responseHeaders.entrySet()) {
                responseContext.getHeaders().putSingle((Object)headers.getKey(), (Object)headers.getValue());
            }
            for (NewCookie cookie : this.responseCookies) {
                responseContext.getHeaders().add((Object)"Set-Cookie", (Object)cookie);
            }
        }
    }
}

