/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.pac4j;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.core.SecurityContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.Pac4JPrincipal;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jax.rs.helpers.RequestPac4JSecurityContext;
import org.pac4j.jax.rs.pac4j.JaxRsContext;

public class JaxRsProfileManager
extends ProfileManager<CommonProfile> {
    public JaxRsProfileManager(JaxRsContext context) {
        super((WebContext)context);
    }

    public void logout() {
        super.logout();
        new RequestPac4JSecurityContext((JaxRsContext)this.context).context().ifPresent(c -> ((Pac4JSecurityContext)c).principal = null);
    }

    public static class Pac4JSecurityContext
    implements SecurityContext {
        private final SecurityContext original;
        private Principal principal;
        private final Collection<CommonProfile> profiles;
        private final JaxRsContext context;

        public Pac4JSecurityContext(SecurityContext original, JaxRsContext context, Collection<CommonProfile> profiles) {
            this.original = original;
            this.context = context;
            this.profiles = profiles;
            this.principal = ProfileHelper.flatIntoOneProfile(profiles).map(Pac4JPrincipal::new).orElse(null);
        }

        public Optional<Collection<CommonProfile>> getProfiles() {
            if (this.principal != null) {
                return Optional.of(Collections.unmodifiableCollection(this.profiles));
            }
            if (this.original instanceof Pac4JSecurityContext) {
                return ((Pac4JSecurityContext)this.original).getProfiles();
            }
            return Optional.empty();
        }

        public JaxRsContext getContext() {
            return this.context;
        }

        public Principal getUserPrincipal() {
            if (this.principal != null) {
                return this.principal;
            }
            return this.original != null ? this.original.getUserPrincipal() : null;
        }

        public boolean isUserInRole(String role) {
            if (this.principal != null) {
                return this.profiles.stream().anyMatch(p -> p.getRoles().contains(role));
            }
            return this.original != null && this.original.isUserInRole(role);
        }

        public boolean isSecure() {
            return this.original != null && this.original.isSecure();
        }

        public String getAuthenticationScheme() {
            if (this.principal != null) {
                return "PAC4J";
            }
            return this.original != null ? this.original.getAuthenticationScheme() : null;
        }
    }
}

