/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.servlet.pac4j;

import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jax.rs.pac4j.JaxRsContext;
import org.pac4j.jax.rs.servlet.pac4j.ServletJaxRsContext;

public class ServletSessionStore
implements SessionStore<JaxRsContext> {
    public HttpSession getHttpSession(JaxRsContext context) {
        assert (context instanceof ServletJaxRsContext);
        return ((ServletJaxRsContext)context).getRequest().getSession();
    }

    public String getOrCreateSessionId(JaxRsContext context) {
        return this.getHttpSession(context).getId();
    }

    public Object get(JaxRsContext context, String key) {
        return this.getHttpSession(context).getAttribute(key);
    }

    public void set(JaxRsContext context, String key, Object value) {
        if (value == null) {
            this.getHttpSession(context).removeAttribute(key);
        } else {
            this.getHttpSession(context).setAttribute(key, value);
        }
    }

    public boolean destroySession(JaxRsContext context) {
        HttpSession session = this.getHttpSession(context);
        session.invalidate();
        return true;
    }

    public Object getTrackableSession(JaxRsContext context) {
        return this.getHttpSession(context);
    }

    public boolean renewSession(JaxRsContext context) {
        HttpSession session = this.getHttpSession(context);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Collections.list(session.getAttributeNames()).forEach(k -> attributes.put((String)k, session.getAttribute(k)));
        session.invalidate();
        HttpSession newSession = this.getHttpSession(context);
        attributes.forEach((arg_0, arg_1) -> ((HttpSession)newSession).setAttribute(arg_0, arg_1));
        return true;
    }

    public SessionStore<JaxRsContext> buildFromTrackableSession(JaxRsContext context, final Object trackableSession) {
        return new ServletSessionStore(){

            @Override
            public HttpSession getHttpSession(JaxRsContext context) {
                return (HttpSession)trackableSession;
            }
        };
    }
}

