package org.gecko.emf.osgi.compare.tests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.gecko.emf.osgi.ResourceSetFactory;
import org.gecko.emf.osgi.compare.api.ModelCompareResultType;
import org.gecko.emf.osgi.compare.api.ModelDiffVisitor;
import org.gecko.emf.osgi.compare.api.ModelObjectMerger;
import org.gecko.emf.osgi.model.test.GenderType;
import org.gecko.emf.osgi.model.test.Person;
import org.gecko.emf.osgi.model.test.TestFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

@RunWith(MockitoJUnitRunner.class)
public class ExampleIntegrationTest extends BasicExampleTest {

	private final BundleContext context = FrameworkUtil.getBundle(ExampleIntegrationTest.class).getBundleContext();
	@Mock
	private ModelDiffVisitor visitor;

	@Before
	public void before() {
		setBundleContext(context);
	}

	@After
	public void after() {
		// TODO add test clear up here
	}

	@Test
	public void testExampleDiffEngine() throws InterruptedException {
		ModelObjectMerger merger = getService(ModelObjectMerger.class, 3000l);
		assertNotNull(merger);
		
		ResourceSetFactory rsf = getService(ResourceSetFactory.class, 3000);
		assertNotNull(rsf);
		ResourceSet rs = rsf.createResourceSet();
		Resource r1 = rs.createResource(URI.createURI("tmp1.test"));
		Person p1 = TestFactory.eINSTANCE.createPerson();
		p1.setFirstName("Mark");
		p1.setGender(GenderType.MALE);
		r1.getContents().add(p1);
		
		Resource r2 = rs.createResource(URI.createURI("tmp2.test"));
		Person p2 = TestFactory.eINSTANCE.createPerson();
		p2.setFirstName("Mark");
		p2.setLastName("Hoffmann");
		p2.setGender(GenderType.MALE);
		r2.getContents().add(p2);
		
		ModelCompareResultType compareResult = merger.compare(r2, r1);
		assertEquals(ModelCompareResultType.COMPARE_SUCCESS, compareResult);
	}
	
	@Test
	public void testDiffVisitor() throws InterruptedException {
		
		ServiceRegistration<ModelDiffVisitor> registration = context.registerService(ModelDiffVisitor.class, visitor, null);
		ModelDiffVisitor mdv = getService(ModelDiffVisitor.class, 3000l);
		assertNotNull(mdv);
		assertEquals(visitor, mdv);
		
		ModelObjectMerger merger = getService(ModelObjectMerger.class, 3000l);
		assertNotNull(merger);
		
		ResourceSetFactory rsf = getService(ResourceSetFactory.class, 3000);
		assertNotNull(rsf);
		ResourceSet rs = rsf.createResourceSet();
		Resource r1 = rs.createResource(URI.createURI("tmp1.test"));
		Person p1 = TestFactory.eINSTANCE.createPerson();
		p1.setFirstName("Mark");
		p1.setGender(GenderType.MALE);
		r1.getContents().add(p1);
		
		Resource r2 = rs.createResource(URI.createURI("tmp2.test"));
		Person p2 = TestFactory.eINSTANCE.createPerson();
		p2.setFirstName("Mark");
		p2.setLastName("Hoffmann");
		p2.setGender(GenderType.MALE);
		r2.getContents().add(p2);
		
		ModelCompareResultType compareResult = merger.compare(r2, r1);
		assertEquals(ModelCompareResultType.COMPARE_SUCCESS, compareResult);
		
		verify(visitor, never()).finishedVisiting(any(Resource.class));
		verify(visitor, times(1)).visitAttributeChange(any(AttributeChange.class));
		verify(visitor, never()).visitReferenceChange(any(ReferenceChange.class));
		
		merger.fireVisitorChanges(r1);
		
		verify(visitor, times(1)).finishedVisiting(any(Resource.class));
		verify(visitor, times(1)).visitAttributeChange(any(AttributeChange.class));
		verify(visitor, never()).visitReferenceChange(any(ReferenceChange.class));
		
		registration.unregister();
	}

}