/**
 * Copyright (c) 2014 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.repository.mongo.cm.entities;

/**
 * This Class holds all data necessary for a EMF mongo database configuration 
 * @author Juergen Albert
 * @since 27.07.2017
 */
public class MongoDatabaseConfig extends ModelObject {

	String name = null;
	String userName = null;
	String userNameEnvironementVariable = null;
	String password = null;
	String passwordEnvironementVariable = null;
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
		firePropertyChange("name", this.name, this.name = name);
	}
	/**
	 * @return the userName
	 */
	public String getUserName() {
		return userName;
	}
	/**
	 * @param userName the userName to set
	 */
	public void setUserName(String userName) {
		this.userName = userName;
		firePropertyChange("userName", this.userName, this.userName = userName);
	}
	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * @param password the password to set
	 */
	public void setPassword(String password) {
		this.password = password;
		firePropertyChange("password", this.password, this.password = password);
	}
	
	/**
	 * Sets the passwordEnvironementVariable.
	 * @param passwordEnvironementVariable the passwordEnvironementVariable to set
	 */
	public void setPasswordEnvironementVariable(String passwordEnvironementVariable) {
		this.passwordEnvironementVariable = passwordEnvironementVariable;
		firePropertyChange("passwordEnvironementVariable", this.passwordEnvironementVariable, this.passwordEnvironementVariable = passwordEnvironementVariable);
	}
	
	/**
	 * Returns the passwordEnvironementVariable.
	 * @return the passwordEnvironementVariable
	 */
	public String getPasswordEnvironementVariable() {
		return passwordEnvironementVariable;
	}
	
	/**
	 * Sets the userNameEnvironementVariable.
	 * @param userNameEnvironementVariable the userNameEnvironementVariable to set
	 */
	public void setUserNameEnvironementVariable(String userNameEnvironementVariable) {
		this.userNameEnvironementVariable = userNameEnvironementVariable;
		firePropertyChange("userNameEnvironementVariable", this.userNameEnvironementVariable, this.userNameEnvironementVariable = userNameEnvironementVariable);
	}
	
	/**
	 * Returns the userNameEnvironementVariable.
	 * @return the userNameEnvironementVariable
	 */
	public String getUserNameEnvironementVariable() {
		return userNameEnvironementVariable;
	}
	
}
