/**
 * Copyright (c) 2014 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.emf.repository.mongo.cm.entities;

import org.gecko.emf.repository.mongo.api.EMFMongoConfiguratorConstants.Type;

/**
 * This Class holds all data necessary for a EMF mongo database configuration 
 * @author Juergen Albert
 * @since 27.07.2017
 */
public class MongoDatabaseConfig extends ModelObject {

	Type type = Type.SINGLETON;
	String name = null;
	String userName = null;
	String password = null;
	String userNameEnvironementVariable = null;
	String passwordEnvironementVariable = null;
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		firePropertyChange("name", this.name, this.name = name);
	}
	/**
	 * @return the userName
	 * @deprecated Use {@link MongoInstanceConfig#getUsername()}
	 */
	public String getUserName() {
		return userName;
	}
	/**
	 * @param userName the userName to set
	 * @deprecated Use {@link MongoInstanceConfig#setUsername(String)}
	 */
	public void setUserName(String userName) {
		firePropertyChange("userName", this.userName, this.userName = userName);
	}
	/**
	 * @return the password
	 * @deprecated Use {@link MongoInstanceConfig#getPassword()}
	 */
	public String getPassword() {
		return password;
	}
	/**
	 * @param password the password to set
	 * @deprecated Use {@link MongoInstanceConfig#setPassword(String)}
	 */
	public void setPassword(String password) {
		firePropertyChange("password", this.password, this.password = password);
	}
	
	/**
	 * Sets the passwordEnvironementVariable.
	 * @param passwordEnvironementVariable the passwordEnvironementVariable to set
	 * @deprecated Use {@link MongoInstanceConfig#setPasswordEnvironmentVariable(String)}
	 */
	public void setPasswordEnvironementVariable(String passwordEnvironementVariable) {
		firePropertyChange("passwordEnvironementVariable", this.passwordEnvironementVariable, this.passwordEnvironementVariable = passwordEnvironementVariable);
	}
	
	/**
	 * Returns the passwordEnvironementVariable.
	 * @return the passwordEnvironementVariable
	 * @deprecated Use {@link MongoInstanceConfig#getPasswordEnvironmentVariable()}
	 */
	public String getPasswordEnvironementVariable() {
		return passwordEnvironementVariable;
	}
	
	/**
	 * Sets the userNameEnvironementVariable.
	 * @param userNameEnvironementVariable the userNameEnvironementVariable to set
	 * @deprecated Use {@link MongoInstanceConfig#setUsernameEnvironmentVariable(String)}
	 */
	public void setUserNameEnvironementVariable(String userNameEnvironementVariable) {
		firePropertyChange("userNameEnvironementVariable", this.userNameEnvironementVariable, this.userNameEnvironementVariable = userNameEnvironementVariable);
	}
	
	/**
	 * Returns the userNameEnvironementVariable.
	 * @return the userNameEnvironementVariable
	 * @deprecated Use {@link MongoInstanceConfig#getUsernameEnvironmentVariable()}
	 */
	public String getUserNameEnvironementVariable() {
		return userNameEnvironementVariable;
	}
	
	public Type getType() {
		return type;
	}

	public void setType(Type type) {
		firePropertyChange("type", this.type, this.type = type);
	}
}
