/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.core;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.gecko.rsa.core.DeSerializationContext;
import org.gecko.rsa.core.SerializationContext;

/**
 * {@link EObject} serialization and de-serialization context
 * @author Mark Hoffmann
 * @since 07.07.2018
 */
public class EObjectDeSerializationContext implements DeSerializationContext, SerializationContext {
	
	public static final String BINARY = "binary";
	public static final String XML = "xml";
	
	private final String contentType;
	private final Map<String, Object> optionsMap = new HashMap<String, Object>();
	
	public static SerializationContext getXMLSerializationContext( ) {
		return new EObjectDeSerializationContext(XML);
	}
	
	public static DeSerializationContext getXMLDeSerializationContext( ) {
		return new EObjectDeSerializationContext(XML);
	}
	
	public static SerializationContext getBinarySerializationContext( ) {
		return new EObjectDeSerializationContext(BINARY);
	}
	
	public static DeSerializationContext getBinaryDeSerializationContext( ) {
		return new EObjectDeSerializationContext(BINARY);
	}

	/**
	 * Creates a new instance.
	 */
	private EObjectDeSerializationContext(String contentType) {
		this.contentType = contentType;
		if (BINARY.equals(contentType)) {
			optionsMap.put(XMLResource.OPTION_BINARY, Boolean.TRUE);
		} else {
			optionsMap.remove(XMLResource.OPTION_BINARY);
		}
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.rsa.core.DeSerializationContext#getContentType()
	 */
	@Override
	public String getContentType() {
		return contentType;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.rsa.core.DeSerializationContext#getSerializationOptions()
	 */
	@Override
	public Map<String, Object> getSerializationOptions() {
		return optionsMap;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.rsa.core.DeSerializationContext#getDeSerializationOptions()
	 */
	@Override
	public Map<String, Object> getDeSerializationOptions() {
		return optionsMap;
	}

}
