/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.core;

import java.util.Map;

/**
 * COntext interface that provides additional serialization information
 * @author Mark Hoffmann
 * @since 07.07.2018
 */
public interface SerializationContext {
	
	/**
	 * Returns the content type to serialize with
	 * @return the content type to serialize with
	 */
	public String getContentType();
	
	/**
	 * Returns serialization options as map
	 * @return serialization options as map or an empty map
	 */
	public Map<String, Object> getSerializationOptions();

}
