/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.core;

import java.io.OutputStream;

import org.osgi.util.promise.Promise;

/**
 * 
 * @author mark
 * @since 07.07.2018
 */
public interface Serializer<T, C extends SerializationContext> {
	
	public SerializationContext getSerializationContext();
	
	public Promise<OutputStream> serialize(T object);
	
	public Promise<OutputStream> serialize(T object, C context);
	
	public Promise<OutputStream> serialize(T object, OutputStream output);
	
	public Promise<OutputStream> serialize(T object, OutputStream output, C context);

}
