/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.gecko.rsa.example.service;

import org.gecko.rsa.example.api.EchoService;
import org.gecko.rsa.rsatest.Address;
import org.gecko.rsa.rsatest.Contact;
import org.gecko.rsa.rsatest.ContactType;
import org.gecko.rsa.rsatest.ContextType;
import org.gecko.rsa.rsatest.Person;
import org.gecko.rsa.rsatest.RSATestFactory;
import org.osgi.service.component.annotations.Component;

@Component(//
    property = {
                "service.exported.interfaces=*", //
                "aries.rsa.port=8201",
                "gecko.rsa.id=echo"
    })
public class EchoServiceImpl implements EchoService {

    @Override
    public String echo(String msg) {
        return msg + " Mark";
    }

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.rsa.example.api.EchoService#getPersonById(java.lang.String)
	 */
	@Override
	public Person getPersonById(String id) {
		Person p = RSATestFactory.eINSTANCE.createPerson();
		p.setFirstName("Mark");
		p.setLastName("Hoffmann");
		p.setId(id);
		Contact c = RSATestFactory.eINSTANCE.createContact();
		c.setValue("m.hoffmann@data-in-motion.biz");
		c.setContext(ContextType.WORK);
		c.setType(ContactType.EMAIL);
		p.getContact().add(c);
		return p;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.rsa.example.api.EchoService#getADdressById(java.lang.String)
	 */
	@Override
	public Address getAddressById(String id) {
		Address a = RSATestFactory.eINSTANCE.createAddress();
		a.setId(id);
		a.setCity("Jena");
		a.setStreet("Kahlaische Strasse");
		a.setNumber("4");
		a.setZip("07745");
		a.setContext(ContextType.WORK);
		return a;
	}

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.rsa.example.api.EchoService#saveAddress(org.gecko.rsa.rsatest.Address)
	 */
	@Override
	public boolean saveAddress(Address a) {
		System.out.println("Saving address " + a);
		return a != null;
	}

}
