/**
 */
package org.gecko.rsa.rsaprovider;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.rsa.rsaprovider.RSAProviderFactory
 * @model kind="package"
 * @generated
 */
public interface RSAProviderPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rsaprovider";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://gecko.io/rsa/provider/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "rsa-provider";

	/**
	 * The package content type ID.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eCONTENT_TYPE = "rsa-provider#1.0.0";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RSAProviderPackage eINSTANCE = org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.rsa.rsaprovider.impl.RSARequestImpl <em>RSA Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.rsa.rsaprovider.impl.RSARequestImpl
	 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getRSARequest()
	 * @generated
	 */
	int RSA_REQUEST = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_REQUEST__ID = 0;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_REQUEST__RESPONSE = 1;

	/**
	 * The feature id for the '<em><b>Service Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_REQUEST__SERVICE_NAME = 2;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_REQUEST__PARAMETER = 3;

	/**
	 * The number of structural features of the '<em>RSA Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_REQUEST_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>RSA Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_REQUEST_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.rsa.rsaprovider.impl.RSAResponseImpl <em>RSA Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.rsa.rsaprovider.impl.RSAResponseImpl
	 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getRSAResponse()
	 * @generated
	 */
	int RSA_RESPONSE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__ID = 0;

	/**
	 * The feature id for the '<em><b>Request</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__REQUEST = 1;

	/**
	 * The feature id for the '<em><b>Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__CODE = 2;

	/**
	 * The feature id for the '<em><b>Error Cause</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__ERROR_CAUSE = 3;

	/**
	 * The feature id for the '<em><b>Error Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__ERROR_TEXT = 4;

	/**
	 * The feature id for the '<em><b>Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__OBJECT = 5;

	/**
	 * The feature id for the '<em><b>EObject Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__EOBJECT_RESULT = 6;

	/**
	 * The feature id for the '<em><b>Void Result</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__VOID_RESULT = 7;

	/**
	 * The feature id for the '<em><b>EObject</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE__EOBJECT = 8;

	/**
	 * The number of structural features of the '<em>RSA Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE_FEATURE_COUNT = 9;

	/**
	 * The number of operations of the '<em>RSA Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RSA_RESPONSE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.rsa.rsaprovider.impl.RequestParameterImpl <em>Request Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.rsa.rsaprovider.impl.RequestParameterImpl
	 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getRequestParameter()
	 * @generated
	 */
	int REQUEST_PARAMETER = 3;

	/**
	 * The feature id for the '<em><b>Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_PARAMETER__NUMBER = 0;

	/**
	 * The feature id for the '<em><b>Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_PARAMETER__OBJECT = 1;

	/**
	 * The number of structural features of the '<em>Request Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_PARAMETER_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Request Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_PARAMETER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.rsa.rsaprovider.impl.EObjectRequestParameterImpl <em>EObject Request Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.rsa.rsaprovider.impl.EObjectRequestParameterImpl
	 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getEObjectRequestParameter()
	 * @generated
	 */
	int EOBJECT_REQUEST_PARAMETER = 2;

	/**
	 * The feature id for the '<em><b>Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_REQUEST_PARAMETER__NUMBER = REQUEST_PARAMETER__NUMBER;

	/**
	 * The feature id for the '<em><b>Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_REQUEST_PARAMETER__OBJECT = REQUEST_PARAMETER__OBJECT;

	/**
	 * The feature id for the '<em><b>EObject</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_REQUEST_PARAMETER__EOBJECT = REQUEST_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>EObject Request Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_REQUEST_PARAMETER_FEATURE_COUNT = REQUEST_PARAMETER_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>EObject Request Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EOBJECT_REQUEST_PARAMETER_OPERATION_COUNT = REQUEST_PARAMETER_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.rsa.rsaprovider.ResponseCodeType <em>Response Code Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.rsa.rsaprovider.ResponseCodeType
	 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getResponseCodeType()
	 * @generated
	 */
	int RESPONSE_CODE_TYPE = 4;

	/**
	 * The meta object id for the '<em>Throwable</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Throwable
	 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getThrowable()
	 * @generated
	 */
	int THROWABLE = 5;


	/**
	 * Returns the meta object for class '{@link org.gecko.rsa.rsaprovider.RSARequest <em>RSA Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RSA Request</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSARequest
	 * @generated
	 */
	EClass getRSARequest();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSARequest#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSARequest#getId()
	 * @see #getRSARequest()
	 * @generated
	 */
	EAttribute getRSARequest_Id();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.rsa.rsaprovider.RSARequest#getResponse <em>Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Response</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSARequest#getResponse()
	 * @see #getRSARequest()
	 * @generated
	 */
	EReference getRSARequest_Response();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSARequest#getServiceName <em>Service Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Service Name</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSARequest#getServiceName()
	 * @see #getRSARequest()
	 * @generated
	 */
	EAttribute getRSARequest_ServiceName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.rsa.rsaprovider.RSARequest#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameter</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSARequest#getParameter()
	 * @see #getRSARequest()
	 * @generated
	 */
	EReference getRSARequest_Parameter();

	/**
	 * Returns the meta object for class '{@link org.gecko.rsa.rsaprovider.RSAResponse <em>RSA Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RSA Response</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse
	 * @generated
	 */
	EClass getRSAResponse();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSAResponse#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#getId()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EAttribute getRSAResponse_Id();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.rsa.rsaprovider.RSAResponse#getRequest <em>Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Request</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#getRequest()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EReference getRSAResponse_Request();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSAResponse#getCode <em>Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Code</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#getCode()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EAttribute getRSAResponse_Code();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSAResponse#getErrorCause <em>Error Cause</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Error Cause</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#getErrorCause()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EAttribute getRSAResponse_ErrorCause();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSAResponse#getErrorText <em>Error Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Error Text</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#getErrorText()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EAttribute getRSAResponse_ErrorText();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSAResponse#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Object</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#getObject()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EAttribute getRSAResponse_Object();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSAResponse#isEObjectResult <em>EObject Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EObject Result</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#isEObjectResult()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EAttribute getRSAResponse_EObjectResult();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RSAResponse#isVoidResult <em>Void Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Void Result</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#isVoidResult()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EAttribute getRSAResponse_VoidResult();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.rsa.rsaprovider.RSAResponse#getEObject <em>EObject</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>EObject</em>'.
	 * @see org.gecko.rsa.rsaprovider.RSAResponse#getEObject()
	 * @see #getRSAResponse()
	 * @generated
	 */
	EReference getRSAResponse_EObject();

	/**
	 * Returns the meta object for class '{@link org.gecko.rsa.rsaprovider.EObjectRequestParameter <em>EObject Request Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EObject Request Parameter</em>'.
	 * @see org.gecko.rsa.rsaprovider.EObjectRequestParameter
	 * @generated
	 */
	EClass getEObjectRequestParameter();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.rsa.rsaprovider.EObjectRequestParameter#getEObject <em>EObject</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>EObject</em>'.
	 * @see org.gecko.rsa.rsaprovider.EObjectRequestParameter#getEObject()
	 * @see #getEObjectRequestParameter()
	 * @generated
	 */
	EReference getEObjectRequestParameter_EObject();

	/**
	 * Returns the meta object for class '{@link org.gecko.rsa.rsaprovider.RequestParameter <em>Request Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Request Parameter</em>'.
	 * @see org.gecko.rsa.rsaprovider.RequestParameter
	 * @generated
	 */
	EClass getRequestParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RequestParameter#getNumber <em>Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number</em>'.
	 * @see org.gecko.rsa.rsaprovider.RequestParameter#getNumber()
	 * @see #getRequestParameter()
	 * @generated
	 */
	EAttribute getRequestParameter_Number();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.rsa.rsaprovider.RequestParameter#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Object</em>'.
	 * @see org.gecko.rsa.rsaprovider.RequestParameter#getObject()
	 * @see #getRequestParameter()
	 * @generated
	 */
	EAttribute getRequestParameter_Object();

	/**
	 * Returns the meta object for enum '{@link org.gecko.rsa.rsaprovider.ResponseCodeType <em>Response Code Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Response Code Type</em>'.
	 * @see org.gecko.rsa.rsaprovider.ResponseCodeType
	 * @generated
	 */
	EEnum getResponseCodeType();

	/**
	 * Returns the meta object for data type '{@link java.lang.Throwable <em>Throwable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Throwable</em>'.
	 * @see java.lang.Throwable
	 * @model instanceClass="java.lang.Throwable"
	 * @generated
	 */
	EDataType getThrowable();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RSAProviderFactory getRSAProviderFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.rsa.rsaprovider.impl.RSARequestImpl <em>RSA Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.rsa.rsaprovider.impl.RSARequestImpl
		 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getRSARequest()
		 * @generated
		 */
		EClass RSA_REQUEST = eINSTANCE.getRSARequest();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_REQUEST__ID = eINSTANCE.getRSARequest_Id();

		/**
		 * The meta object literal for the '<em><b>Response</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RSA_REQUEST__RESPONSE = eINSTANCE.getRSARequest_Response();

		/**
		 * The meta object literal for the '<em><b>Service Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_REQUEST__SERVICE_NAME = eINSTANCE.getRSARequest_ServiceName();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RSA_REQUEST__PARAMETER = eINSTANCE.getRSARequest_Parameter();

		/**
		 * The meta object literal for the '{@link org.gecko.rsa.rsaprovider.impl.RSAResponseImpl <em>RSA Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.rsa.rsaprovider.impl.RSAResponseImpl
		 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getRSAResponse()
		 * @generated
		 */
		EClass RSA_RESPONSE = eINSTANCE.getRSAResponse();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_RESPONSE__ID = eINSTANCE.getRSAResponse_Id();

		/**
		 * The meta object literal for the '<em><b>Request</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RSA_RESPONSE__REQUEST = eINSTANCE.getRSAResponse_Request();

		/**
		 * The meta object literal for the '<em><b>Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_RESPONSE__CODE = eINSTANCE.getRSAResponse_Code();

		/**
		 * The meta object literal for the '<em><b>Error Cause</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_RESPONSE__ERROR_CAUSE = eINSTANCE.getRSAResponse_ErrorCause();

		/**
		 * The meta object literal for the '<em><b>Error Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_RESPONSE__ERROR_TEXT = eINSTANCE.getRSAResponse_ErrorText();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_RESPONSE__OBJECT = eINSTANCE.getRSAResponse_Object();

		/**
		 * The meta object literal for the '<em><b>EObject Result</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_RESPONSE__EOBJECT_RESULT = eINSTANCE.getRSAResponse_EObjectResult();

		/**
		 * The meta object literal for the '<em><b>Void Result</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RSA_RESPONSE__VOID_RESULT = eINSTANCE.getRSAResponse_VoidResult();

		/**
		 * The meta object literal for the '<em><b>EObject</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RSA_RESPONSE__EOBJECT = eINSTANCE.getRSAResponse_EObject();

		/**
		 * The meta object literal for the '{@link org.gecko.rsa.rsaprovider.impl.EObjectRequestParameterImpl <em>EObject Request Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.rsa.rsaprovider.impl.EObjectRequestParameterImpl
		 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getEObjectRequestParameter()
		 * @generated
		 */
		EClass EOBJECT_REQUEST_PARAMETER = eINSTANCE.getEObjectRequestParameter();

		/**
		 * The meta object literal for the '<em><b>EObject</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EOBJECT_REQUEST_PARAMETER__EOBJECT = eINSTANCE.getEObjectRequestParameter_EObject();

		/**
		 * The meta object literal for the '{@link org.gecko.rsa.rsaprovider.impl.RequestParameterImpl <em>Request Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.rsa.rsaprovider.impl.RequestParameterImpl
		 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getRequestParameter()
		 * @generated
		 */
		EClass REQUEST_PARAMETER = eINSTANCE.getRequestParameter();

		/**
		 * The meta object literal for the '<em><b>Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REQUEST_PARAMETER__NUMBER = eINSTANCE.getRequestParameter_Number();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REQUEST_PARAMETER__OBJECT = eINSTANCE.getRequestParameter_Object();

		/**
		 * The meta object literal for the '{@link org.gecko.rsa.rsaprovider.ResponseCodeType <em>Response Code Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.rsa.rsaprovider.ResponseCodeType
		 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getResponseCodeType()
		 * @generated
		 */
		EEnum RESPONSE_CODE_TYPE = eINSTANCE.getResponseCodeType();

		/**
		 * The meta object literal for the '<em>Throwable</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see java.lang.Throwable
		 * @see org.gecko.rsa.rsaprovider.impl.RSAProviderPackageImpl#getThrowable()
		 * @generated
		 */
		EDataType THROWABLE = eINSTANCE.getThrowable();

	}

} //RSAProviderPackage
