/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.gecko.rsa.provider.ser;

import java.io.Serializable;

import org.osgi.framework.Version;

public class VersionMarker implements Serializable {
    private static final long serialVersionUID = 4725855052866235835L;

    private String version;
    
    public VersionMarker() {
    }
    
    public VersionMarker(Version version) {
        this.version = version.toString();
    }
    
    public String getVersion() {
        return version;
    }
    public void setVersion(String version) {
        this.version = version;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VersionMarker)) {
            return false;
        }
        VersionMarker other = (VersionMarker) obj;
        return version.equals(other.version);
    }
}
