/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.runtime.application;

import java.util.Map;

import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ScheduledApplication;

/**
 * Interface to add scheduled applications
 * @author Mark Hoffmann
 * @since 23.03.2018
 */
public interface ApplicationScheduler {
	
	/**
	 * Schedules an application
	 * @param descriptor the application descriptor
	 * @param scheduleId the schedule id
	 * @param arguments the handle arguments
	 * @param topic the event trigger topic 
	 * @param eventFilter the optional event filter
	 * @param recurring <code>true</code>, if the event occurs recurring on each event
	 * @return the {@link ScheduledApplication} instance
	 * @throws InvalidSyntaxException
	 * @throws ApplicationException
	 */
	public ScheduledApplication schedule(ApplicationDescriptor descriptor, String scheduleId, Map<String, Object> arguments, String topic, String eventFilter, boolean recurring) throws InvalidSyntaxException, ApplicationException;
	
	/**
	 * Un-schedules an application for the schedule id 
	 * @param scheduleId the id of the application to be removed
	 * @throws InvalidSyntaxException
	 * @throws ApplicationException
	 */
	public void unschedule(String scheduleId) throws InvalidSyntaxException, ApplicationException;

}
