/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.runtime.showcase.configuration;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;

import javax.ws.rs.core.Application;

import org.gecko.emf.repository.mongo.api.EMFMongoConfiguratorConstants;
import org.gecko.rest.jersey.provider.JerseyConstants;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.JaxrsWhiteboardConstants;

/**
 * This component contains a server configuration of the single services
 * @author mark
 * @since 16.01.2018
 */
@Component(immediate = true, enabled = true)
public class ShowCaseConfiguration {

	@Reference
	private ConfigurationAdmin configAdmin;
	
	private ServiceRegistration<Application> jaxRsApplicationRegistration;
	/*
	 * JaxRS/REST server configuration
	 */
	private Configuration jaxRsWhiteboardConfiguration;
	/*
	 * Persistence configuration
	 */
	private Configuration emfRepositoryConfiguration;

	/**
	 * Called on component activation 
	 * @param context
	 * @throws IOException
	 */
	@Activate
	public void activate(BundleContext context) throws IOException {
		
		/*
		 * Mount the application 'myapp' that will become available under: myapp
		 * http://localhost:8082/test/myapp
		 */
		Dictionary<String, Object> applicationProperties = new Hashtable<>();
		applicationProperties.put(JaxrsWhiteboardConstants.JAX_RS_APPLICATION_BASE, "myapp");
		applicationProperties.put(JaxrsWhiteboardConstants.JAX_RS_NAME, "MyApplication");
		// link application to the whiteboard below
		applicationProperties.put(JaxrsWhiteboardConstants.JAX_RS_WHITEBOARD_TARGET, "(test=true)");
		applicationProperties.put("application.id", "myapp");
		applicationProperties.put("emf", Boolean.TRUE);
		jaxRsApplicationRegistration = context.registerService(Application.class, new Application(), applicationProperties);
		
		/*
		 * Create a JaxRS whiteboard under http://localhost:8082/test
		 */
		Dictionary<String, Object> whiteboardProperties = new Hashtable<>();
		whiteboardProperties.put(JerseyConstants.JERSEY_WHITEBOARD_NAME, "Test JaxRS Whiteboard");
		whiteboardProperties.put(JerseyConstants.JERSEY_PORT, Integer.valueOf(8082));
		whiteboardProperties.put(JerseyConstants.JERSEY_HOST, "localhost");
		whiteboardProperties.put(JerseyConstants.JERSEY_CONTEXT_PATH, "test");
		whiteboardProperties.put("test", "true");
		
		jaxRsWhiteboardConfiguration = configAdmin.createFactoryConfiguration("JaxRsWhiteboardComponent", "?");
		jaxRsWhiteboardConfiguration.update(whiteboardProperties);
		
		/*
		 * Create a EMF Repository configruation for a Mongo-repository
		 */
		emfRepositoryConfiguration = configAdmin.createFactoryConfiguration(EMFMongoConfiguratorConstants.EMF_MONGO_REPOSITORY_CONFIGURATOR_CONFIGURATION_NAME, "?");
		
		/*
		 * mongo.instances=test
		 * test.baseUris=mongodb://localhost
		 * test.databases=test
		 */
		Dictionary<String, Object> configProperties = new Hashtable<>();
		configProperties.put("mongo.instances", "test");
		configProperties.put("test.baseUris", "mongodb://localhost:27017");
		configProperties.put("test.databases", "test");
		configProperties.put("test." + EMFMongoConfiguratorConstants.MONGO_REPOSITORY_TYPE, EMFMongoConfiguratorConstants.Type.PROTOTYPE.toString());
		
		emfRepositoryConfiguration.update(configProperties);
		
//		Dictionary<String, Object> mongoProperties = new Hashtable<>();
//		String clientId = "testClient";
//		String clientUri = "mongodb://localhost:27017";
//		mongoProperties.put(MongoClientProvider.PROP_CLIENT_ID, clientId);
//		mongoProperties.put(MongoClientProvider.PROP_URI, clientUri);
//		clientConfig = configAdmin.createFactoryConfiguration(ConfigurationProperties.CLIENT_PID, "?");
//		clientConfig.update(mongoProperties);
//		
//
//		// create data base provider configuration
//		databaseConfig = configAdmin.createFactoryConfiguration(ConfigurationProperties.DATABASE_PID, "?");
//
//		// add service properties
//		String dbAlias = "testDB";
//		String db = "test";
//		Dictionary<String, Object> dbp = new Hashtable<String, Object>();
//		dbp.put(MongoDatabaseProvider.PROP_ALIAS, dbAlias);
//		dbp.put(MongoDatabaseProvider.PROP_DATABASE, db);
//		databaseConfig.update(dbp);
//		
//		repositoryConfig = configAdmin.createFactoryConfiguration("mongoRepository", "?");
//		Dictionary<String, Object> properties = new Hashtable<>();
//
//		String repoId = "test_repo";
//		properties.put(EMFRepository.PROP_ID, repoId);
//		properties.put(EMFRepository.PROP_BASE_URI, clientUri + "/" + db);
//		properties.put(Constants.SERVICE_SCOPE, "prototype");
//		repositoryConfig.update(properties);
		
	}
	
	@Deactivate
	public void deactivate() throws IOException {
		jaxRsWhiteboardConfiguration.delete();
		emfRepositoryConfiguration.delete();
		jaxRsApplicationRegistration.unregister();
	}
	
}
