/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.runtime.showcase;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.gecko.emf.osgi.model.test.GenderType;
import org.gecko.emf.osgi.model.test.Person;
import org.gecko.emf.osgi.model.test.TestFactory;
import org.gecko.emf.osgi.model.test.TestPackage;
import org.gecko.emf.repository.EMFRepository;
import org.gecko.runtime.boot.annotation.RequireGeckoRuntime;
import org.gecko.runtime.logging.annotation.RequireSLF4J;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.jaxrs.whiteboard.JaxrsWhiteboardConstants;

/**
 * Simple resource example showing:
 * - EMF Persistence
 * - QVT model transformation
 * - JaxRS
 * - Logging 
 * @author mark
 * @since 16.01.2018
 */
@Component(
		service = Object.class,
		enabled = true,
		scope = ServiceScope.PROTOTYPE,
		property = {
				JaxrsWhiteboardConstants.JAX_RS_RESOURCE + "=true",
				JaxrsWhiteboardConstants.JAX_RS_NAME + "=PersonResource",
				JaxrsWhiteboardConstants.JAX_RS_APPLICATION_SELECT + "=(" + JaxrsWhiteboardConstants.JAX_RS_NAME + "=*)"
		})
@Path("/")
@RequireSLF4J() 
@RequireGeckoRuntime
public class PersonResource {
	
	private final Logger julLogger = Logger.getLogger(PersonResource.class.getName());
//	@Reference
//	private LogService osgiLogger;
	@Reference(scope = ReferenceScope.PROTOTYPE)
	private EMFRepository repository;
//	@Reference
//	private ModelTransformationFactory modelTransformationFactory;
	
	@Activate
	public void activate() {
		julLogger.info("JUL-Logging - The person resource was activated");
//		osgiLogger.log(LogService.LOG_INFO, "OSGi-Logging - The person resource was activated");
	}
	
	/**
	 * Creates a person, persist it into the mongo database and transformed this instance, simply appending the 
	 * String 'in' to the first name and last name. The Method returns the mapped instance as JSON
	 * @return
	 * @throws URISyntaxException
	 */
	@GET
	@Path("person")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPerson() throws URISyntaxException {
		Person person = TestFactory.eINSTANCE.createPerson();
		person.setGender(GenderType.MALE);
		person.setFirstName("Emil");
		person.setLastName("Tester");
		repository.save(person);
		
		julLogger.info("JUL-Logging - Saved person " + person);
//		osgiLogger.log(LogService.LOG_INFO, "OSGi-Logging - Saved person " + person);
		
		URL resource = FrameworkUtil.getBundle(getClass()).getResource("PersonTransformation.qvto");
		java.net.URI uri = resource.toURI();
		URI mapping = URI.createHierarchicalURI(uri.getScheme(), uri.getAuthority(), null, uri.getPath().split("/"), null, null);
		
		ResourceSet resourceSet = repository.getResourceSet();
		resourceSet.getPackageRegistry().put(TestPackage.eNS_URI, TestPackage.eINSTANCE);
//		ModelTransformator transformator = modelTransformationFactory.createModelTransformator(resourceSet, mapping);
		
//		Person result = (Person) transformator.startTransformation(person);
//		julLogger.info("JUL-Logging - Transformed person " + person.getLastName() + " using QVT into " + result.getLastName());
//		osgiLogger.log(LogService.LOG_INFO, "OSGi-Logging - Transformed person " + person.getLastName() + " using QVT into " + result.getLastName());
		
		julLogger.info("JUL-Logging - Transformed person " + person.getLastName() + " using QVT into " + person.getLastName());
//		osgiLogger.log(LogService.LOG_INFO, "OSGi-Logging - Transformed person " + person.getLastName() + " using QVT into " + person.getLastName());
		
		return Response.ok(person).header("Access-Control-Allow-Origin", "*").build();
//		return Response.ok(result).header("Access-Control-Allow-Origin", "*").build();
	}

}
