/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.internal.EnvironmentRegistryImpl;
import org.eclipse.ocl.internal.OCLDebugOptions;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLPlugin
extends EMFPlugin {
    public static final String EMPTY_STRING = "";
    private static final String PREFIX_THROWING = "THROWN ";
    private static final String SEPARATOR_SPACE = " ";
    private static final String PARENTHESIS_OPEN = "(";
    private static final String PARENTHESIS_CLOSE = ")";
    private static final String SEPARATOR_METHOD = "#";
    private static final String PREFIX_CATCHING = "CAUGHT ";
    public static OCLPlugin INSTANCE = new OCLPlugin();
    public static Implementation plugin;
    private static boolean traceAll;

    static {
        traceAll = Boolean.getBoolean("org.eclipse.ocl.debug");
    }

    public OCLPlugin() {
        super(new ResourceLocator[0]);
    }

    public static String getPluginId() {
        return OCLPlugin.getPlugin() != null ? OCLPlugin.getPlugin().getBundle().getSymbolicName() : "org.eclipse.ocl";
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static OCLPlugin getInstance() {
        return INSTANCE;
    }

    public static void catching(Class<?> clazz, String methodName, Throwable throwable) {
        if (OCLPlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_CATCHING)) {
            OCLPlugin.trace(PREFIX_CATCHING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static void throwing(Class<?> clazz, String methodName, Throwable throwable) {
        if (OCLPlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_THROWING)) {
            OCLPlugin.trace(PREFIX_THROWING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static boolean shouldTrace(String option) {
        if (OCLPlugin.getPlugin() != null) {
            if (OCLPlugin.getPlugin().isDebugging()) {
                return Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option));
            }
            return false;
        }
        return traceAll || Boolean.getBoolean(option);
    }

    public static void trace(String message) {
        System.out.println("[OCL] " + message);
    }

    public static void error(int code, String message) {
        OCLPlugin.error(code, message, null);
    }

    public static void error(int code, String message, Throwable throwable) {
        OCLPlugin.log(4, code, message, throwable);
    }

    public static void info(String message) {
        OCLPlugin.info(0, message);
    }

    public static void info(int code, String message) {
        OCLPlugin.info(code, message, null);
    }

    public static void info(int code, String message, Throwable throwable) {
        OCLPlugin.log(1, code, message, throwable);
    }

    public static void warning(int code, String message) {
        OCLPlugin.warning(code, message, null);
    }

    public static void warning(int code, String message, Throwable throwable) {
        OCLPlugin.log(2, code, message, throwable);
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? EMPTY_STRING : message;
        try {
            if (OCLPlugin.getPlugin() != null) {
                OCLPlugin.getPlugin().log(new Status(severity, OCLPlugin.getPluginId(), code, msg, throwable));
            } else if (OCLPlugin.shouldTrace(OCLDebugOptions.DEBUG)) {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            OCLPlugin.catching(OCLPlugin.class, "log", iae);
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            EnvironmentRegistryImpl envreg;
            super.start(context);
            EnvironmentRegistryImpl environmentRegistryImpl = envreg = (EnvironmentRegistryImpl)Environment.Registry.INSTANCE;
            environmentRegistryImpl.getClass();
            environmentRegistryImpl.new EnvironmentRegistryImpl.RegistryReader(OCLPlugin.getInstance()).readRegistry();
        }
    }
}

