/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.util.pushstreams;

import java.util.Map;
import java.util.concurrent.BlockingQueue;

import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamBuilder;

/**
 * Helper class to consigure push streams
 * @author Mark Hoffmann
 * @since 29.11.2018
 */
public class PushStreamHelper {
	
	public static <T> PushStream<T> createPushstream(PushStreamBuilder<T, BlockingQueue<PushEvent<? extends T>>> builder, Map<String, Object> properties) {
		if (builder == null) {
			throw new IllegalArgumentException("Cannot create push stream from null builder");
		}
		return builder.build();
	}

}
