/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.util.pushstreams;

/**
 * Constants for configuring a push stream
 * @author Mark Hoffmann
 * @since 29.11.2018
 */
public interface PushStreamConstants {
	
	public static final String PROP_BUFFER_SIZE = "pushstream.bufferSize";
	public static final String PROP_PARALLELISM = "pushstream.parallelism";
	public static final String PROP_EXECUTOR = "pushstream.executorService";
	public static final String PROP_SCHEDULED_EXECUTOR = "pushstream.scheduledExecutorService";
	public static final String PROP_BUFFER_QUEUE = "pushstream.bufferQueue";
	public static final String PROP_QUEUE_POLICY = "pushstream.queue.policy";
	public static final String PROP_QUEUE_POLICY_OPTION = "pushstream.queue.policyOption";
	public static final String PROP_PUSHBACK_POLICY = "pushstream.pushback.policy";
	public static final String PROP_PUSHBACK_POLICY_TIME = "pushstream.pushback.policyTime";
	public static final String PROP_PUSHBACK_POLICY_OPTION = "pushstream.pushback.policyOption";
	public static final String PROP_PUSHBACK_POLICY_OPTION_BY_NAME = "pushstream.pushback.policyOption.name";
	public static final String PROP_ACK_FILTER = "pushstream.ack.filter";
	public static final String PROP_ACK_CONSUMER = "pushstream.ack.function";
	public static final String PROP_NACK_CONSUMER = "pushstream.nack.function";
	public static final String PROP_ACK_ERROR = "pushstream.ack.errorFunction";
	
}
