/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.features;

import java.lang.reflect.Method;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Providers;
import org.pac4j.jax.rs.annotations.Pac4JCallback;
import org.pac4j.jax.rs.annotations.Pac4JLogout;
import org.pac4j.jax.rs.annotations.Pac4JSecurity;
import org.pac4j.jax.rs.filters.CallbackFilter;
import org.pac4j.jax.rs.filters.LogoutFilter;
import org.pac4j.jax.rs.filters.SecurityFilter;
import org.pac4j.jax.rs.helpers.AnnotationsHelper;

public class Pac4JSecurityFeature
implements DynamicFeature,
Feature {
    @Context
    private Providers providers;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Pac4JLogout lAnn;
        Pac4JCallback cbAnn;
        assert (resourceInfo != null);
        assert (context != null);
        Class clazz = resourceInfo.getResourceClass();
        Pac4JSecurity classSecAnn = clazz == null ? null : AnnotationsHelper.getClassLevelAnnotation(clazz, Pac4JSecurity.class);
        Method method = resourceInfo.getResourceMethod();
        Pac4JSecurity methSecAnn = method == null ? null : AnnotationsHelper.getMethodLevelAnnotation(method, Pac4JSecurity.class);
        Pac4JSecurity secAnn = methSecAnn != null ? methSecAnn : classSecAnn;
        if (secAnn != null && !secAnn.ignore()) {
            if (secAnn.multiProfile().length > 1) {
                throw new IllegalArgumentException("multiProfile parameter in @Pac4JSecurity is not expected to have more than one value");
            }
            if (secAnn.skipResponse().length > 1) {
                throw new IllegalArgumentException("skipResponse parameter in @Pac4JSecurity is not expected to have more than one value");
            }
            SecurityFilter filter = new SecurityFilter(this.providers);
            String clients = secAnn.clients().length == 0 ? null : String.join((CharSequence)",", secAnn.clients());
            filter.setAuthorizers(String.join((CharSequence)",", secAnn.authorizers()));
            filter.setClients(clients);
            filter.setMatchers(String.join((CharSequence)",", secAnn.matchers()));
            filter.setMultiProfile(secAnn.multiProfile().length == 0 ? null : Boolean.valueOf(secAnn.multiProfile()[0]));
            filter.setSkipResponse(secAnn.skipResponse().length == 0 ? null : Boolean.valueOf(secAnn.skipResponse()[0]));
            context.register((Object)filter);
        }
        Pac4JCallback pac4JCallback = cbAnn = method == null ? null : AnnotationsHelper.getMethodLevelAnnotation(method, Pac4JCallback.class);
        if (cbAnn != null) {
            if (cbAnn.defaultUrl().length > 1) {
                throw new IllegalArgumentException("defaultUrl parameter in @Pac4JCallback is not expected to have more than one value");
            }
            if (cbAnn.saveInSession().length > 1) {
                throw new IllegalArgumentException("saveInSession parameter in @Pac4JCallback is not expected to have more than one value");
            }
            if (cbAnn.multiProfile().length > 1) {
                throw new IllegalArgumentException("multiProfile parameter in @Pac4JCallback is not expected to have more than one value");
            }
            if (cbAnn.renewSession().length > 1) {
                throw new IllegalArgumentException("renewSession parameter in @Pac4JCallback is not expected to have more than one value");
            }
            if (cbAnn.skipResponse().length > 1) {
                throw new IllegalArgumentException("skipResponse parameter in @Pac4JCallback is not expected to have more than one value");
            }
            if (cbAnn.defaultClient().length > 1) {
                throw new IllegalArgumentException("defaultClient parameter in @Pac4JCallback is not expected to have more than one value");
            }
            CallbackFilter filter = new CallbackFilter(this.providers);
            filter.setSaveInSession(cbAnn.saveInSession().length == 0 ? null : Boolean.valueOf(cbAnn.saveInSession()[0]));
            filter.setMultiProfile(cbAnn.multiProfile().length == 0 ? null : Boolean.valueOf(cbAnn.multiProfile()[0]));
            filter.setRenewSession(cbAnn.renewSession().length == 0 ? null : Boolean.valueOf(cbAnn.renewSession()[0]));
            filter.setDefaultUrl(cbAnn.defaultUrl().length == 0 ? null : cbAnn.defaultUrl()[0]);
            filter.setSkipResponse(cbAnn.skipResponse().length == 0 ? null : Boolean.valueOf(cbAnn.skipResponse()[0]));
            filter.setDefaultClient(cbAnn.defaultClient().length == 0 ? null : cbAnn.defaultClient()[0]);
            context.register((Object)filter);
        }
        Pac4JLogout pac4JLogout = lAnn = method == null ? null : AnnotationsHelper.getMethodLevelAnnotation(method, Pac4JLogout.class);
        if (lAnn != null) {
            if (lAnn.defaultUrl().length > 1) {
                throw new IllegalArgumentException("defaultUrl parameter in @Pac4JLogout is not expected to have more than one value");
            }
            if (lAnn.logoutUrlPattern().length > 1) {
                throw new IllegalArgumentException("logoutUrlPattern parameter in @Pac4JLogout is not expected to have more than one value");
            }
            if (lAnn.skipResponse().length > 1) {
                throw new IllegalArgumentException("skipResponse parameter in @Pac4JLogout is not expected to have more than one value");
            }
            LogoutFilter filter = new LogoutFilter(this.providers);
            filter.setDefaultUrl(lAnn.defaultUrl().length == 0 ? null : lAnn.defaultUrl()[0]);
            filter.setLogoutUrlPattern(lAnn.logoutUrlPattern().length == 0 ? null : lAnn.logoutUrlPattern()[0]);
            filter.setSkipResponse(lAnn.skipResponse().length == 0 ? null : Boolean.valueOf(lAnn.skipResponse()[0]));
            filter.setLocalLogout(lAnn.localLogout().length == 0 ? null : Boolean.valueOf(lAnn.localLogout()[0]));
            filter.setDestroySession(lAnn.destroySession().length == 0 ? null : Boolean.valueOf(lAnn.destroySession()[0]));
            filter.setCentralLogout(lAnn.centralLogout().length == 0 ? null : Boolean.valueOf(lAnn.centralLogout()[0]));
            context.register((Object)filter);
        }
    }

    public boolean configure(FeatureContext context) {
        return true;
    }
}

