/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.filters;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.ext.Providers;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.jax.rs.filters.AbstractFilter;
import org.pac4j.jax.rs.pac4j.JaxRsContext;
import org.pac4j.jax.rs.pac4j.JaxRsProfileManager;

@Priority(value=2000)
public class LogoutFilter
extends AbstractFilter {
    private LogoutLogic<Object, JaxRsContext> logoutLogic;
    private String defaultUrl;
    private String logoutUrlPattern;
    private Boolean localLogout;
    private Boolean destroySession;
    private Boolean centralLogout;

    public LogoutFilter(Providers providers) {
        super(providers);
    }

    @Override
    protected void filter(JaxRsContext context) throws IOException {
        Config config = this.getConfig();
        this.buildLogic(config).perform((WebContext)context, config, this.adapter(config), context.getAbsolutePath(this.defaultUrl, false), context.getAbsolutePath(this.logoutUrlPattern, false), this.localLogout, this.destroySession, this.centralLogout);
    }

    protected LogoutLogic<Object, JaxRsContext> buildLogic(Config config) {
        if (this.logoutLogic != null) {
            return this.logoutLogic;
        }
        if (config.getLogoutLogic() != null) {
            return config.getLogoutLogic();
        }
        DefaultLogoutLogic logic = new DefaultLogoutLogic();
        logic.setProfileManagerFactory(JaxRsProfileManager::new);
        return logic;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }

    public Boolean getLocalLogout() {
        return this.localLogout;
    }

    public void setLocalLogout(Boolean localLogout) {
        this.localLogout = localLogout;
    }

    public Boolean getDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(Boolean destroySession) {
        this.destroySession = destroySession;
    }

    public Boolean getCentralLogout() {
        return this.centralLogout;
    }

    public void setCentralLogout(Boolean centralLogout) {
        this.centralLogout = centralLogout;
    }

    public LogoutLogic<Object, JaxRsContext> getLogoutLogic() {
        return this.logoutLogic;
    }

    public void setLogoutLogic(LogoutLogic<Object, JaxRsContext> applicationLogoutLogic) {
        this.logoutLogic = applicationLogoutLogic;
    }
}

