/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jax.rs.filters;

import java.io.IOException;
import java.util.Collection;
import javax.annotation.Priority;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Providers;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.jax.rs.filters.AbstractFilter;
import org.pac4j.jax.rs.pac4j.JaxRsContext;
import org.pac4j.jax.rs.pac4j.JaxRsProfileManager;

@Priority(value=1000)
public class SecurityFilter
extends AbstractFilter {
    private SecurityLogic<Object, JaxRsContext> securityLogic;
    private String clients;
    private String authorizers;
    private String matchers;
    private Boolean multiProfile;

    public SecurityFilter(Providers providers) {
        super(providers);
    }

    @Override
    protected void filter(JaxRsContext context) throws IOException {
        Config config = this.getConfig();
        this.buildLogic(config).perform((WebContext)context, config, (SecurityGrantedAccessAdapter)new SecurityGrantedAccessOutcome(), this.adapter(config), this.clients, this.authorizers, this.matchers, this.multiProfile, new Object[0]);
    }

    protected SecurityLogic<Object, JaxRsContext> buildLogic(Config config) {
        if (this.securityLogic != null) {
            return this.securityLogic;
        }
        if (config.getSecurityLogic() != null) {
            return config.getSecurityLogic();
        }
        DefaultSecurityLogic logic = new DefaultSecurityLogic();
        logic.setProfileManagerFactory(JaxRsProfileManager::new);
        return logic;
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    public boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public SecurityLogic<Object, JaxRsContext> getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic<Object, JaxRsContext> securityLogic) {
        this.securityLogic = securityLogic;
    }

    private static class SecurityGrantedAccessOutcome
    implements SecurityGrantedAccessAdapter<Object, JaxRsContext> {
        private SecurityGrantedAccessOutcome() {
        }

        public Object adapt(JaxRsContext context, Collection<CommonProfile> profiles, Object ... parameters) {
            SecurityContext original = context.getRequestContext().getSecurityContext();
            context.getRequestContext().setSecurityContext((SecurityContext)new JaxRsProfileManager.Pac4JSecurityContext(original, context, profiles));
            return null;
        }
    }
}

