/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.adapter.amqp.client;

import org.gecko.osgi.messaging.SimpleMessagingContext;

/**
 * Implementation of the messaging context for the AMQP protocol
 * @author Mark Hoffmann
 * @since 15.02.2018
 */
public class AMQPContext extends SimpleMessagingContext {
	
	public static enum RoutingType {
		DIRECT,
		TOPIC,
		FANOUT,
		HEADER
	}
	
	private String queueName;
	private String exchangeName;
	private String routingKey;
	private RoutingType routingType = RoutingType.DIRECT;
	private boolean durable = false;
	private boolean exclusive = false;
	private boolean autoDelete = false;
	private boolean queueMode = false;
	private boolean exchangeMode = false;
	private boolean autoAcknowledge = false;
	
	/**
	 * Returns the autoAcknowledge.
	 * @return the autoAcknowledge
	 */
	public boolean isAutoAcknowledge() {
		return autoAcknowledge;
	}

	/**
	 * Sets the autoAcknowledge.
	 * @param autoAcknowledge the autoAcknowledge to set
	 */
	public void setAutoAcknowledge(boolean autoAcknowledge) {
		this.autoAcknowledge = autoAcknowledge;
	}

	/**
	 * Returns the routingType.
	 * @return the routingType
	 */
	public String getRoutingType() {
		return routingType.toString().toLowerCase();
	}

	/**
	 * Sets the routingType.
	 * @param routingType the routingType to set
	 */
	public void setRoutingType(RoutingType routingType) {
		this.routingType = routingType;
	}

	/**
	 * Returns the queueName.
	 * @return the queueName
	 */
	public String getQueueName() {
		return queueName;
	}
	
	/**
	 * Sets the queueName.
	 * @param queueName the queueName to set
	 */
	public void setQueueName(String queueName) {
		this.queueName = queueName;
	}
	
	/**
	 * Returns the exchangeName.
	 * @return the exchangeName
	 */
	public String getExchangeName() {
		return exchangeName;
	}
	
	/**
	 * Sets the exchangeName.
	 * @param exchangeName the exchangeName to set
	 */
	public void setExchangeName(String exchangeName) {
		this.exchangeName = exchangeName;
	}

	/**
	 * Returns the routingKey.
	 * @return the routingKey
	 */
	public String getRoutingKey() {
		return routingKey;
	}

	/**
	 * Sets the routingKey.
	 * @param routingKey the routingKey to set
	 */
	public void setRoutingKey(String routingKey) {
		this.routingKey = routingKey;
	}

	/**
	 * Returns the durable.
	 * @return the durable
	 */
	public boolean isDurable() {
		return durable;
	}

	/**
	 * Sets the durable.
	 * @param durable the durable to set
	 */
	public void setDurable(boolean durable) {
		this.durable = durable;
	}

	/**
	 * Returns the exclusive.
	 * @return the exclusive
	 */
	public boolean isExclusive() {
		return exclusive;
	}

	/**
	 * Sets the exclusive.
	 * @param exclusive the exclusive to set
	 */
	public void setExclusive(boolean exclusive) {
		this.exclusive = exclusive;
	}

	/**
	 * Returns the autoDelete.
	 * @return the autoDelete
	 */
	public boolean isAutoDelete() {
		return autoDelete;
	}

	/**
	 * Sets the autoDelete.
	 * @param autoDelete the autoDelete to set
	 */
	public void setAutoDelete(boolean autoDelete) {
		this.autoDelete = autoDelete;
	}

	/**
	 * Returns the queueMode.
	 * @return the queueMode
	 */
	boolean isQueueMode() {
		return queueMode;
	}

	/**
	 * Sets the queueMode.
	 * @param queueMode the queueMode to set
	 */
	void setQueueMode(boolean queueMode) {
		this.queueMode = queueMode;
	}

	/**
	 * Returns the exchangeMode.
	 * @return the exchangeMode
	 */
	public boolean isExchangeMode() {
		return exchangeMode;
	}

	/**
	 * Sets the exchangeMode.
	 * @param exchangeMode the exchangeMode to set
	 */
	void setExchangeMode(boolean exchangeMode) {
		this.exchangeMode = exchangeMode;
	}
	
}
