/**
 * Copyright (c) 2012 - 2017 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.osgi.messaging;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import org.osgi.util.pushstream.PushEvent;

/**
 * Context object that can be used to provide additional configuration to the adapter
 * @author Mark Hoffmann
 * @since 10.10.2017
 */
public interface MessagingContext {
	
	int getBufferSize();
	
	int getParallelism();
	
	ExecutorService getExecutor();
	
	ScheduledExecutorService getScheduler();
	
	BlockingQueue<PushEvent<? extends Message>> getBufferQueue();

}
