/**
 * 
 */
package org.gecko.osgi.messaging;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventSource;
import org.osgi.util.pushstream.PushStreamBuilder;
import org.osgi.util.pushstream.PushStreamProvider;

/**
 * Helper class for PushStream creation
 * @author Mark Hoffmann
 *
 */
public class PushStreamHelper {
	
	public static PushStreamBuilder<Message, BlockingQueue<PushEvent<? extends Message>>> buildPushStreamWithContext(MessagingContext context, PushEventSource<Message> source) {
		PushStreamProvider psp = new PushStreamProvider();
		PushStreamBuilder<Message, BlockingQueue<PushEvent<? extends Message>>> builder = psp.buildStream(source);
		if (context != null) {
			if (context.getBufferQueue() != null) {
				builder.withBuffer(context.getBufferQueue());
			}
			if (context.getExecutor() != null) {
				builder.withExecutor(context.getExecutor());
			}
			if (context.getScheduler() != null) {
				builder.withScheduler(context.getScheduler());
			}
			if (context.getParallelism() > 1) {
				builder.withParallelism(context.getParallelism());
			}
			if (context.getBufferSize() > 0 && context.getBufferQueue() == null) {
				builder.withBuffer(new LinkedBlockingQueue<PushEvent<? extends Message>>(context.getBufferSize()));
			}
		}
		return builder;
	}

}
