/**
 * 
 */
package org.gecko.osgi.messaging;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import org.osgi.util.pushstream.PushEvent;

/**
 * Default implementation for a messaging context
 * @author Mark Hoffmann
 *
 */
public class SimpleMessagingContext implements MessagingContext {
	
	private int bufferSize = -1;
	private int parallelism = 1;
	private ExecutorService executor = null;
	private ScheduledExecutorService scheduler = null;
	private BlockingQueue<PushEvent<? extends Message>> bufferQueue = null;

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContext#getBufferSize()
	 */
	@Override
	public int getBufferSize() {
		return bufferSize;
	}
	
	void setBufferSize(int bufferSize) {
		this.bufferSize = bufferSize;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContext#getParallelism()
	 */
	@Override
	public int getParallelism() {
		return parallelism;
	}
	
	void setParallelism(int parallelism) {
		this.parallelism = parallelism;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContext#getExecutor()
	 */
	@Override
	public ExecutorService getExecutor() {
		return executor;
	}
	
	void setExecutor(ExecutorService executor) {
		this.executor = executor;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContext#getScheduler()
	 */
	@Override
	public ScheduledExecutorService getScheduler() {
		return scheduler;
	}
	
	void setScheduler(ScheduledExecutorService scheduler) {
		this.scheduler = scheduler;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContext#getBufferQueue()
	 */
	@Override
	public BlockingQueue<PushEvent<? extends Message>> getBufferQueue() {
		return bufferQueue;
	}
	
	void setBufferQueue(BlockingQueue<PushEvent<? extends Message>> bufferQueue) {
		this.bufferQueue = bufferQueue;
	}

}
