/**
 * 
 */
package org.gecko.osgi.messaging;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import org.osgi.util.pushstream.PushEvent;

/**
 * SimpleMessagingContextBuilder that implements base information
 * @author Mark Hoffmann
 *
 */
public class SimpleMessagingContextBuilder implements MessagingContextBuilder {
	
	private int bufferSize = 0;
	private int parallelism = 1;
	private ExecutorService executor = null;
	private ScheduledExecutorService scheduler = null;
	private BlockingQueue<PushEvent<? extends Message>> bufferQueue = null;

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContextBuilder#build()
	 */
	@Override
	public MessagingContext build() {
		return buildContext(new SimpleMessagingContext());
	}
	
	protected <T extends SimpleMessagingContext> T buildContext(T ctx) {
		if (bufferSize > 0) {
			ctx.setBufferSize(bufferSize);
		}
		if (parallelism > 1) {
			ctx.setParallelism(parallelism);
		}
		if (executor != null) {
			ctx.setExecutor(executor);
		}
		if (scheduler != null) {
			ctx.setScheduler(scheduler);
		}
		if (bufferQueue != null) {
			ctx.setBufferQueue(bufferQueue);
		}
		return ctx;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContextBuilder#withBuffer(int)
	 */
	@Override
	public MessagingContextBuilder withBuffer(int size) {
		if (bufferSize > 0) {
			this.bufferSize = size;
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContextBuilder#withBufferQueue(java.util.concurrent.BlockingQueue)
	 */
	@Override
	public MessagingContextBuilder withBufferQueue(BlockingQueue<PushEvent<? extends Message>> bufferQueue) {
		if (bufferQueue != null) {
			this.bufferQueue = bufferQueue;
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContextBuilder#withParallelism(int)
	 */
	@Override
	public MessagingContextBuilder withParallelism(int parallelism) {
		if (parallelism > 1) {
			this.parallelism = parallelism;
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContextBuilder#withExecutor(java.util.concurrent.ExecutorService)
	 */
	@Override
	public MessagingContextBuilder withExecutor(ExecutorService executor) {
		if (executor != null) {
			this.executor = executor;
		}
		return this;
	}

	/* (non-Javadoc)
	 * @see org.gecko.osgi.messaging.MessagingContextBuilder#withScheduler(java.util.concurrent.ScheduledExecutorService)
	 */
	@Override
	public MessagingContextBuilder withScheduler(ScheduledExecutorService scheduler) {
		if (scheduler != null) {
			this.scheduler = scheduler;
		}
		return this;
	}

}
