/**
 * Copyright (c) 2012 - 2019 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.minio;

/**
 * Execption that is thrown, if the driver is not available for certain reasons
 * @author Mark Hoffmann
 * @since 13.05.2019
 */
public class MinioClientException extends Exception {

	/** serialVersionUID */
	private static final long serialVersionUID = 4160925867371377194L;

	/**
	 * Creates a new instance.
	 */
	public MinioClientException(String message) {
		super(message);
	}
	
	/**
	 * Creates a new instance.
	 */
	public MinioClientException(String message, Throwable cause) {
		super(message, cause);
	}
}
