package org.gecko.bnd.eclipse.launcher.util;

import org.eclipse.equinox.launcher.JNIBridge;
import org.gecko.bnd.eclipse.launcher.pre.EclipseLauncherConstants;

public class SplashHandler extends Thread {
		
		private final EclipseLauncherConstants props;
		private final JNIBridge bridge;
		
		/**
		 * 
		 */
		public SplashHandler(EclipseLauncherConstants properties, JNIBridge bridge) {
			this.props = properties;
			this.bridge = bridge;
		}
		
		@Override
		public void run() {
			takeDownSplash();
		}

		public void updateSplash() {
			if (this.bridge != null && !props.splashDown) {
				this.bridge.updateSplash();
			}
		}
		
		/*
		 * Take down the splash screen. 
		 */
		public void takeDownSplash() {
			if (this.props.splashDown || this.bridge == null) // splash is already down
				return;

			this.props.splashDown = this.bridge.takeDownSplash();
			System.clearProperty(EclipseLauncherConstants.SPLASH_HANDLE);

			try {
				Runtime.getRuntime().removeShutdownHook(this);
			} catch (Throwable e) {
				// OK to ignore this, happens when the VM is already shutting down
			}
		}
	}