/**
 * Copyright (c) 2012 - 2019 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.api;

import org.osgi.service.remoteserviceadmin.EndpointDescription;

/**
 * Handler that can be registered at the {@link ImportingEndpointManager}. 
 * It gets informed, when to export descriptions to the other frameworks, if a remote
 * service was detected in our runtime.
 * 
 * Implementations are responsible to translate the service descriptions into their 
 * protocol specific format.
 * @author Mark Hoffmann
 * @since 03.04.2019
 */
public interface ExportEndpointHandler {
	
	/**
	 * Exports an end-point description
	 * @param endpoint the end-point to be exported
	 * @throws Exception
	 */
	public void exportServiceDescription(EndpointDescription endpoint) throws Exception;

	/**
	 * Modifies an end-point description, that has to be exported
	 * @param endpoint the end-point to be modified
	 * @throws Exception
	 */
	public void modifyServiceDescription(EndpointDescription endpoint) throws Exception;

	/**
	 * Removed an end-point description, that has been exported
	 * @param endpoint the end-point to be removed
	 * @throws Exception
	 */
	public void removeServiceDescription(EndpointDescription endpoint) throws Exception;

}
