/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.discovery.ma;

import org.gecko.osgi.messaging.MessagingService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.util.tracker.ServiceTracker;

/**
 * Bundle activator for the message adapter discovery
 * @author Mark Hoffmann
 * @since 02.07.2018
 */
public class Activator implements BundleActivator {
	
    private ServiceTracker<EndpointEventListener, EndpointEventListener> listenerTracker;
    private ServiceTracker<MessagingService, MessagingService> messagingTracker;

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		MessageAdapterDiscovery maDiscovery = new MessageAdapterDiscovery(context);
		messagingTracker = new MessageAdapterTracker(context, maDiscovery);
		messagingTracker.open();
	}

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
        listenerTracker.close();
        messagingTracker.close();
	}

    
    /**
     * Service tracker that tracks {@link EndpointEventListener}
     * @author Mark Hoffmann
     * @since 02.07.2018
     */
    private final class MessageAdapterTracker extends ServiceTracker<MessagingService, MessagingService> {
    	
    	private final MessageAdapterDiscovery maDiscovery;
    	
    	private MessageAdapterTracker(BundleContext context, MessageAdapterDiscovery configDiscovery) {
    		super(context, MessagingService.class, null);
    		this.maDiscovery = configDiscovery;
    	}
    	
    	/* 
    	 * (non-Javadoc)
    	 * @see org.osgi.util.tracker.ServiceTracker#addingService(org.osgi.framework.ServiceReference)
    	 */
    	@Override
    	public MessagingService addingService(ServiceReference<MessagingService> reference) {
    		MessagingService messaging = super.addingService(reference);
    		maDiscovery.start(messaging);
    		return messaging;
    	}
    	
    	/* 
    	 * (non-Javadoc)
    	 * @see org.osgi.util.tracker.ServiceTracker#removedService(org.osgi.framework.ServiceReference, java.lang.Object)
    	 */
    	@Override
    	public void removedService(ServiceReference<MessagingService> reference, MessagingService endpointListener) {
    		maDiscovery.stop();
    		super.removedService(reference, endpointListener);
    	}
    }

}
