/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.discovery.ma.converter;

import java.util.List;
import java.util.Map;

import org.gecko.rsa.core.converter.PropertiesMapper;
import org.gecko.rsa.model.rsa.Property;
import org.gecko.rsa.model.rsa.RSAFactory;
import org.gecko.rsa.model.rsa.util.RSASwitch;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/**
 * Converter that converts from the model based endpoint description into an OSGi RSA {@link EndpointDescription}
 * @author Mark Hoffmann
 * @since 02.07.2018
 */
public class EndpointDescriptionConverter extends RSASwitch<EndpointDescription> {
	
	private final PropertiesMapper mapper = new PropertiesMapper();
	
	/* 
	 * (non-Javadoc)
	 * @see org.gecko.rsa.model.rsa.util.RSASwitch#caseEndpointDescription(org.gecko.rsa.model.rsa.EndpointDescription)
	 */
	@Override
	public EndpointDescription caseEndpointDescription(org.gecko.rsa.model.rsa.EndpointDescription object) {
		Map<String, Object> properties = mapper.toProps(object.getProperty());
		EndpointDescription ed = new EndpointDescription(properties);
		return ed;
	}
	
	/**
	 * Maps from an OSGi RSA {@link EndpointDescription} into the model based instance
	 * @param object the end-point description
	 * @return the model equivalent
	 */
	public org.gecko.rsa.model.rsa.EndpointDescription caseOSGiEndpointDescription(EndpointDescription object) {
		org.gecko.rsa.model.rsa.EndpointDescription ed = RSAFactory.eINSTANCE.createEndpointDescription();
		List<Property> properties = mapper.fromProps(object.getProperties());
		ed.getProperty().addAll(properties);
		return ed;
	}

}
