/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.discovery.ma.util;

/**
 * Constants implementation
 * @author Mark Hoffmann
 * @since 02.07.2018
 */
public interface MADiscoveryConstants {

	/** Constant for topic names to get service description from foreign hosts */
	public static final String TOPIC_ADD_SERVICE = "gecko/rsa/discovery/add";
	public static final String TOPIC_MODIFY_SERVICE = "gecko/rsa/discovery/modify";
	public static final String TOPIC_REMOVE_SERVICE = "gecko/rsa/discovery/remove";
	
	/** Constant for a topic to get all initial announciations from foreign hosts */
	public static final String TOPIC_ANNOUNCED_SERVICE = "gecko/rsa/discovery/announce/%s";

	/** Constant for a topic to send a 'get description' command to foreign hosts */
	public static final String TOPIC_GET_DESCRIPTION = "gecko/rsa/discovery/descriptions";
}
