/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.gecko.rsa.example.consumer;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.gecko.rsa.example.api.EchoService;
import org.gecko.rsa.rsatest.Address;
import org.gecko.rsa.rsatest.ContextType;
import org.gecko.rsa.rsatest.Person;
import org.gecko.rsa.rsatest.RSATestFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class EchoConsumer {
    
    EchoService echoService;
    
    ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor();

    @Activate
    public void activate() {
    	System.out.println("Activate");
        ses.scheduleWithFixedDelay(()->executeStuff(), 0, 60, TimeUnit.SECONDS);
    }
    
    @Deactivate
    public void deactivate() {
    	System.out.println("De-Activate");
    	ses.shutdown();
    	ses.shutdownNow();
    }
    
    public void executeStuff() {
    	System.out.println("Sending to echo service");
        System.out.println(echoService.echo("Good morning"));
        Person p = echoService.getPersonById("mh");
        System.out.println("Found Person: " + p);
        List<Address> a = echoService.getAddressById("jks4");
        p.getAddress().addAll(a);
        p.getAddress().forEach((adr)->System.out.println("Person address is: " + adr));
        
        Address ap = RSATestFactory.eINSTANCE.createAddress();
        ap.setContext(ContextType.PRIVATE);
        ap.setCity("Gera");
        ap.setStreet("Kurt-Keicher-Strasse");
        ap.setNumber("93");
        ap.setZip("07545");
        boolean r = echoService.saveAddress(ap);
        System.out.println("Saving address was successful=" + r);
    }
    

    @Reference
    public void setEchoService(EchoService echoService) {
        this.echoService = echoService;
    }
    
}
