package org.gecko.rsa.topology;

import org.gecko.rsa.api.helper.FilterHelper;
import org.gecko.rsa.topology.exports.TopologyManagerExport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.util.tracker.ServiceTracker;

/**
 * {@link ServiceTracker} that tracks {@link EndpointEventListener}
 * @author Mark Hoffmann
 * @since 30.08.2018
 */
public class EndpointEventListenerTracker extends ServiceTracker<EndpointEventListener, EndpointEventListener> {
	
    private TopologyManagerExport tmExport;

    public EndpointEventListenerTracker(BundleContext context, TopologyManagerExport tmExport) {
        super(context, EndpointEventListener.class, null);
        this.tmExport = tmExport;
    }

    /* 
     * (non-Javadoc)
     * @see org.osgi.util.tracker.ServiceTracker#addingService(org.osgi.framework.ServiceReference)
     */
    @Override
    public EndpointEventListener addingService(ServiceReference<EndpointEventListener> reference) {
    	EndpointEventListener listener = super.addingService(reference);
        this.tmExport.addEPListener(listener, FilterHelper.getFiltersFromEEL(reference));
        return listener;
    }

    /* 
     * (non-Javadoc)
     * @see org.osgi.util.tracker.ServiceTracker#modifiedService(org.osgi.framework.ServiceReference, java.lang.Object)
     */
    @Override
    public void modifiedService(ServiceReference<EndpointEventListener> reference, EndpointEventListener listener) {
        this.tmExport.addEPListener(listener, FilterHelper.getFiltersFromEEL(reference));
        super.modifiedService(reference, listener);
    }

    /* 
     * (non-Javadoc)
     * @see org.osgi.util.tracker.ServiceTracker#removedService(org.osgi.framework.ServiceReference, java.lang.Object)
     */
    @Override
    public void removedService(ServiceReference<EndpointEventListener> reference, EndpointEventListener listener) {
        this.tmExport.removeEPListener(listener);
        super.removedService(reference, listener);
    }
    
}