/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.topology;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * {@link ThreadPoolExecutor} for the Topology manager
 * @author Mark Hoffmann
 * @since 30.08.2018
 */
public class TopologyTPExecutor extends ThreadPoolExecutor {
	
	private static class TopologyThreadFactory implements ThreadFactory {
		
		private final String name;
		private int cnt = 0;

		/**
		 * Creates a new instance.
		 */
		public TopologyThreadFactory(String name) {
			this.name = name;
		}
		
		/* 
		 * (non-Javadoc)
		 * @see java.util.concurrent.ThreadFactory#newThread(java.lang.Runnable)
		 */
		@Override
		public Thread newThread(Runnable r) {
			Thread t = new Thread(r, name + "-" + cnt);
			return t;
		}
	};
	
	/**
	 * Creates a new instance.
	 */
	public TopologyTPExecutor(int coreSize, int maxSize, int timeout, TimeUnit unit, String name) {
		super(coreSize, maxSize, timeout, unit, new LinkedBlockingQueue<Runnable>(), new TopologyThreadFactory(name));
	}

}
