/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.gecko.rsa.topology.exports;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import org.gecko.rsa.api.ExportPolicy;
import org.osgi.framework.ServiceReference;

/**
 * The default is to not customize the way services are exported
 */
public class DefaultExportPolicy implements ExportPolicy {

    /* 
     * (non-Javadoc)
     * @see org.gecko.rsa.api.ExportPolicy#additionalParameters(org.osgi.framework.ServiceReference)
     */
    @Override
    public Map<String, ?> additionalParameters(ServiceReference<?> sref) {
        return new HashMap<String, Object>();
    }
    
    /**
     * Returns the service properties for this export policy
     * @return the service properties for this export policy
     */
    public static Dictionary<String, Object> getExportPolicyProperties() {
    	Dictionary<String, Object> properties = new Hashtable<String, Object>();
        properties.put("name", "default");
        return properties;
    }

}
