/**
 * Copyright (c) 2012 - 2019 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.rsa.topology.imports.local;

import java.util.Collection;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

/**
 * Provider that gathers filters for all services in our local framework.
 * This provider creates filters for new services and delegates them to 
 * the TopologyManager import part. This is registered as a ServiceEventListener that
 * will be triggered by the discovery. 
 * To avoid useless triggers for service imports, the discovery only triggers imports, for 
 * potential interested services. 
 * These information are gathered here and are represented as filter. If we have a change here,
 * that can be a service change, removal or add, the filters are updated.
 * 
 * On each filter update the service registration of the TopologyManager import service listener, will update
 * its service properties. That can force the topology manager to be removed or added as interested party to the 
 * discovery.
 * @author mark
 * @since 04.04.2019
 */
public class LocalServiceInterestsProvider implements ListenerHook, FindHook {

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.hooks.service.ListenerHook#added(java.util.Collection)
	 */
	@Override
	public void added(Collection<ListenerInfo> listeners) {
		// TODO Auto-generated method stub

	}

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.hooks.service.ListenerHook#removed(java.util.Collection)
	 */
	@Override
	public void removed(Collection<ListenerInfo> listeners) {
		// TODO Auto-generated method stub

	}

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.hooks.service.FindHook#find(org.osgi.framework.BundleContext, java.lang.String, java.lang.String, boolean, java.util.Collection)
	 */
	@Override
	public void find(BundleContext context, String name, String filter, boolean allServices,
			Collection<ServiceReference<?>> references) {
		// TODO Auto-generated method stub
		
	}

}
