/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.runtime.resources;

import java.io.File;
import java.net.URI;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Provider for URI or/ and files depending on the configuration
 * @author Mark Hoffmann
 */
@ProviderType
public interface GeckoResourcesProvider {
	
	/**
	 * Returns the name of this provider
	 * @return the name of this provider
	 */
	public String getName();
	
	/**
	 * Returns the {@link URI} for this provider
	 * @return the {@link URI} for this provider
	 */
	public URI getURI();
	
	/**
	 * Returns the file instance for this provider
	 * @return the file instance for this provider
	 */
	public File getFile();
	
	/**
	 * Returns this URI as {@link String}
	 * @return this URI as {@link String}
	 */
	public String getURIString();

}
