/**
 * 
 */
package org.gecko.runtime.bnd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.lib.io.IO;

/**
 * @author jalbert
 *
 */
public class GeckoBndRun extends Run{

	/**
	 * Create a Bndrun that will be stand alone if it contains -standalone. In
	 * that case the given workspace is ignored. Otherwise, the workspace must
	 * be a valid workspace.
	 */
	public static GeckoBndRun createGeckoBndRunrun(Workspace workspace, File file) throws Exception {
		Processor processor;
		if (workspace != null) {
			GeckoBndRun run = new GeckoBndRun(workspace, file);
			if (run.getProperties().get(STANDALONE) == null) {
				return run;
			}
			processor = run;
		} else {
			processor = new Processor();
			processor.setProperties(file);
		}

		Workspace standaloneWorkspace = Workspace.createStandaloneWorkspace(processor, file.toURI());
		GeckoBndRun run = new GeckoBndRun(standaloneWorkspace, file);
		return run;
	}
	
	public GeckoBndRun(Workspace workspace, File projectDir, File propertiesFile) throws Exception {
		super(workspace, projectDir, propertiesFile);
	}

	public GeckoBndRun(Workspace workspace, File file) throws Exception {
		super(workspace, file);
	}
	
	public void exportGecko(File outputDir) throws Exception {
		
		File exportDir = new File(outputDir, getName().substring(0, getName().indexOf(".bndrun")));
		File etcDir = new File(exportDir, "etc");
		File logsDir = new File(exportDir, "logs");
		File libDir = new File(exportDir, "lib");

		etcDir.mkdirs();
		logsDir.mkdirs();
		libDir.mkdirs();
		
		export(null, true, new File(libDir, "launch.jar"));
		
		InputStream launchConfStream = getClass().getClassLoader().getResourceAsStream("script/gecko.conf");
		InputStream launchScriptStream = getClass().getClassLoader().getResourceAsStream("script/gecko.sh");
		
		File launchScript = new File(exportDir, "gecko.sh");
		IO.copy(launchScriptStream, launchScript);
		launchScript.setExecutable(true);
		
		IO.copy(launchConfStream, new File(exportDir, "gecko.conf"));

		InputStream logback = getClass().getClassLoader().getResourceAsStream("etc/logback.xml");
		InputStream logback_consoleOnly = getClass().getClassLoader().getResourceAsStream("etc/logback_console_only.xml");
		
		IO.copy(logback, new File(etcDir, "logback.xml"));
		
		IO.copy(logback_consoleOnly, new File(etcDir, "logback_console_only.xml"));
	}
	
	/* (non-Javadoc)
	 * @see aQute.bnd.build.Project#export(java.lang.String, boolean, java.io.File)
	 */
	@SuppressWarnings("resource")
	@Override
	public void export(String runFilePath, boolean keep, File output) throws Exception {
		prepare();

		Project packageProject;
		if (runFilePath == null || runFilePath.length() == 0 || ".".equals(runFilePath)) {
			packageProject = this;
		} else {
			File runFile = IO.getFile(getBase(), runFilePath);
			if (!runFile.isFile())
				throw new IOException(
						String.format("Run file %s does not exist (or is not a file).", runFile.getAbsolutePath()));
			packageProject = new Run(getWorkspace(), getBase(), runFile);
		}
		packageProject.clear();

		try (ProjectLauncher launcher = packageProject.getProjectLauncher()) {
			launcher.setKeep(keep);
			try (Jar jar = launcher.executable()) {
				getInfo(launcher);
				jar.write(output);
			}
		}
	}

}
