/**
 * 
 */
package org.gecko.runtime.bnd.export;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap.SimpleEntry;
import java.util.Map;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Project;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.export.Exporter;

/**
 * BND Exporter Plugin for a Gecko Runtime
 * 
 * @author Juergen Albert
 */
@BndPlugin(name = "gecko")
public class GeckoExporter implements Exporter{

	private final static Logger logger = LoggerFactory.getLogger(GeckoExporter.class);
	
	private static String[] TYPES = new String[] {"gecko.export"};
	
	@Override
	public String[] getTypes() {
		return TYPES;
	}

	@Override
	public Entry<String, Resource> export(String type, Project project, Map<String, String> options) throws Exception {

		Jar jar = new Jar(project.getName().replace(".bndrun", ""));
		jar.setDoNotTouchManifest();

		URL runtimeUrl = getClass().getClassLoader().getResource("runtime/lib/placeholder.txt");
		String rus = runtimeUrl.toString();
		if(rus.lastIndexOf('!') != -1) {
			rus = rus.substring(0, rus.lastIndexOf('!')+2);
		}
		Jar releng = Jar.fromResource("releng", Resource.fromURL(new URL(rus)));
		releng.getDirectories().forEach((k, v) -> {
			if(v != null && !k.equals("runtime") && k.startsWith("runtime")) {
				v.entrySet().stream().map(e -> new SimpleEntry<String, Resource>(e.getKey().substring(e.getKey().indexOf('/') + 1), e.getValue()))
				.forEach(e -> jar.putResource(e.getKey(), e.getValue()));
			}
		});
			
		
		if(options.containsKey("gecko.runtime.dir")) {
			File runtimeFolder = new File(options.get("gecko.runtime.dir"));
			logger.info("Including resource from {} with projectbase {} in runtime export", runtimeFolder.toURI().toString(), project.getBase());
			if(runtimeFolder.listFiles() != null) {
				for (File child : runtimeFolder.listFiles()) {
					addToJar(jar, child, "");
				}
			}
		}
		
		Entry<String, Resource> export = project.export("bnd.executablejar", null);
		jar.putResource("lib/launch.jar", export.getValue());
//		File outFolder = new File(project.getBase(), "/generated/runtime");
//		if(!outFolder.exists()) {
//			outFolder.mkdirs();
//		}
		return new SimpleEntry<>(jar.getName() + ".zip", new JarResource(jar, true));
	}

	/**
	 * @param jar
	 * @param child
	 * @throws IOException 
	 */
	private void addToJar(Jar jar, File file, String dir) throws IOException {
		if(file.isFile()) {
			jar.remove(dir + file.getName());
			jar.putResource(dir + file.getName(), new FileResource(file), true);
		} else {
			for (File child : file.listFiles()) {
				addToJar(jar, child, dir + file.getName() + "/");
			}
		}
	}
}
